/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial.schema;

import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.serial.schema.Type;
import java.nio.charset.StandardCharsets;

public class ArraySchema<T>
implements DingoSchema<T[]> {
    private int index;
    private boolean isKey;
    private boolean allowNull = true;
    private DingoSchema<T> elementSchema;

    public ArraySchema(DingoSchema<T> elementSchema) {
        this.elementSchema = elementSchema;
    }

    @Override
    public Type getType() {
        return Type.ARRAY;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getValueLengthV2() {
        return 0;
    }

    @Override
    public int getWithNullTagLength() {
        return 1;
    }

    @Override
    public int getLength() {
        if (this.allowNull) {
            return this.elementSchema.getLength() + 1;
        }
        return this.elementSchema.getLength();
    }

    private int getLength(T[] data) {
        int sum = 0;
        int elementSchemaSize = 0;
        switch (this.elementSchema.getType()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: {
                elementSchemaSize = this.elementSchema.getLength();
                if (this.allowNull) {
                    sum = 5 + elementSchemaSize * data.length;
                    break;
                }
                sum = 4 + elementSchemaSize * data.length;
                break;
            }
            case STRING: {
                for (T value : data) {
                    byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                    sum += bytes.length;
                }
                if (this.allowNull) {
                    sum += 5;
                    break;
                }
                sum += 4;
                break;
            }
        }
        return sum;
    }

    private int getLengthV2(T[] data) {
        int sum = 0;
        int elementSchemaSize = 0;
        switch (this.elementSchema.getType()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: {
                elementSchemaSize = this.elementSchema.getLength();
                sum = 4 + elementSchemaSize * data.length;
                break;
            }
            case STRING: {
                for (T value : data) {
                    byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                    sum += bytes.length;
                }
                sum += 4;
                break;
            }
        }
        return sum;
    }

    @Override
    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    @Override
    public boolean isAllowNull() {
        return this.allowNull;
    }

    @Override
    public void encodeKey(Buf buf, T[] data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyV2(Buf buf, T[] data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyForUpdate(Buf buf, T[] data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyForUpdateV2(Buf buf, T[] data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public T[] decodeKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public T[] decodeKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public T[] decodeKeyPrefix(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void skipKey(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void skipKeyV2(Buf buf) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeKeyPrefix(Buf buf, T[] data) {
        throw new RuntimeException("Array cannot be key");
    }

    @Override
    public void encodeValue(Buf buf, T[] data) {
        if (this.allowNull) {
            if (data == null) {
                buf.ensureRemainder(1);
                buf.write((byte)0);
            } else {
                buf.ensureRemainder(this.getLength(data));
                buf.write((byte)1);
                buf.writeInt(data.length);
                for (T element : data) {
                    this.elementSchema.encodeValue(buf, element);
                }
            }
        } else {
            buf.ensureRemainder(this.getLength(data));
            buf.writeInt(data.length);
            for (T element : data) {
                this.elementSchema.encodeValue(buf, element);
            }
        }
    }

    @Override
    public int encodeValueV2(Buf buf, T[] data) {
        int len = 0;
        if (this.allowNull) {
            if (data == null) {
                return 0;
            }
            len = this.getLengthV2(data);
            buf.ensureRemainder(len);
            buf.writeInt(data.length);
            for (T element : data) {
                this.elementSchema.encodeValue(buf, element);
            }
        } else {
            len = this.getLengthV2(data);
            buf.ensureRemainder(len);
            buf.writeInt(data.length);
            for (T element : data) {
                this.elementSchema.encodeValue(buf, element);
            }
        }
        return len;
    }

    @Override
    public T[] decodeValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return null;
        }
        int length = buf.readInt();
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.elementSchema.decodeValue(buf);
        }
        return array;
    }

    @Override
    public T[] decodeValueV2(Buf buf) {
        int length = buf.readInt();
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.elementSchema.decodeValue(buf);
        }
        return array;
    }

    @Override
    public void skipValue(Buf buf) {
        if (this.allowNull && buf.read() == 0) {
            return;
        }
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.elementSchema.skipValue(buf);
        }
    }

    @Override
    public void skipValueV2(Buf buf) {
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.elementSchema.skipValueV2(buf);
        }
    }
}

