/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial;

import io.dingodb.sdk.common.serial.schema.DingoSchema;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static void sortSchema(List<DingoSchema> schemas) {
        int flag = 1;
        for (int i = 0; i < schemas.size() - flag; ++i) {
            if (schemas.get(i).isKey() || !Utils.lengthNotSure(schemas.get(i))) continue;
            int target = schemas.size() - flag++;
            while (Utils.lengthNotSure(schemas.get(target)) || schemas.get(target).isKey()) {
                if (--target == i) {
                    return;
                }
                ++flag;
            }
            schemas.set(target, schemas.set(i, schemas.get(target)));
        }
    }

    public static boolean lengthNotSure(DingoSchema schema) {
        return schema.getLength() == 0;
    }

    public static int[] getApproPerRecordSize(List<DingoSchema> schemas) {
        int keySize = 13;
        int valueSize = 4;
        for (DingoSchema schema : schemas) {
            if (schema.isKey()) {
                keySize += schema.getLength() == 0 ? 100 : schema.getLength();
                continue;
            }
            valueSize += schema.getLength() == 0 ? 100 : schema.getLength();
        }
        return new int[]{keySize, valueSize};
    }

    public static int[] getApproPerRecordSizeV2(List<DingoSchema> schemas) {
        int keySize = 13;
        int valueSize = 4;
        for (DingoSchema schema : schemas) {
            if (schema.isKey()) {
                keySize += schema.getWithNullTagLength() == 1 ? 100 : schema.getWithNullTagLength();
                continue;
            }
            valueSize += schema.getValueLengthV2() == 0 ? 100 : schema.getValueLengthV2();
        }
        return new int[]{keySize, valueSize};
    }
}

