/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial;

import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.BufImpl;
import io.dingodb.sdk.common.serial.Utils;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import java.util.Arrays;
import java.util.List;

public class RecordEncoder {
    private final int schemaVersion;
    private List<DingoSchema> schemas;
    private final long id;
    private int keyBufSize;
    private int valueBufSize;
    private int valueColumnCount;
    private int codecVersion;

    private byte[] encodeValueV1(Object[] record) {
        BufImpl valueBuf = new BufImpl(this.valueBufSize);
        this.encodeSchemaVersion(valueBuf);
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) continue;
            schema.encodeValue(valueBuf, record[schema.getIndex()]);
        }
        return valueBuf.getBytes();
    }

    private byte[] encodeValueV2(Object[] record) {
        int cntNotNullCols = 0;
        int cntNullCols = 0;
        int totalLength = 0;
        int cntNotNullPos = 4;
        int cntNullPos = cntNotNullPos + 2;
        int idPos = cntNullPos + 2;
        int offsetPos = idPos + 2 * this.valueColumnCount;
        int dataPos = offsetPos + 4 * this.valueColumnCount;
        totalLength = 8;
        BufImpl valueBuf = new BufImpl(dataPos + this.valueBufSize, dataPos);
        this.encodeSchemaVersion(0, valueBuf);
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) continue;
            int index = schema.getIndex();
            Object column = record[index];
            if (column == null) {
                ++cntNullCols;
                valueBuf.writeShort(idPos, (short)index);
                idPos += 2;
                valueBuf.writeInt(offsetPos, -1);
                offsetPos += 4;
                continue;
            }
            ++cntNotNullCols;
            valueBuf.writeShort(idPos, (short)index);
            idPos += 2;
            valueBuf.writeInt(offsetPos, dataPos);
            offsetPos += 4;
            dataPos += schema.encodeValueV2(valueBuf, record[schema.getIndex()]);
        }
        valueBuf.writeShort(cntNotNullPos, (short)cntNotNullCols);
        valueBuf.writeShort(cntNullPos, (short)cntNullCols);
        return valueBuf.getBytes();
    }

    private int getValueColumnCount() {
        int count = 0;
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) continue;
            ++count;
        }
        return count;
    }

    public RecordEncoder(int schemaVersion, List<DingoSchema> schemas, long id) {
        this.schemaVersion = schemaVersion;
        this.schemas = schemas;
        this.id = id;
        this.codecVersion = 2;
        if (this.codecVersion == 2) {
            int[] size = Utils.getApproPerRecordSizeV2(schemas);
            this.keyBufSize = size[0];
            this.valueBufSize = size[1];
        } else {
            int[] size = Utils.getApproPerRecordSize(schemas);
            this.keyBufSize = size[0];
            this.valueBufSize = size[1];
        }
        this.valueColumnCount = this.getValueColumnCount();
    }

    public RecordEncoder(int schemaVersion, long id) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.codecVersion = 2;
    }

    public RecordEncoder(int codecVersion, int schemaVersion, List<DingoSchema> schemas, long id) {
        this.schemaVersion = schemaVersion;
        this.schemas = schemas;
        this.id = id;
        this.codecVersion = codecVersion;
        if (this.codecVersion == 2) {
            int[] size = Utils.getApproPerRecordSizeV2(schemas);
            this.keyBufSize = size[0];
            this.valueBufSize = size[1];
        } else {
            int[] size = Utils.getApproPerRecordSize(schemas);
            this.keyBufSize = size[0];
            this.valueBufSize = size[1];
        }
        this.valueColumnCount = this.getValueColumnCount();
    }

    public RecordEncoder(int codecVersion, int schemaVersion, long id) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.codecVersion = codecVersion;
    }

    private void encodePrefix(Buf buf) {
        buf.write((byte)114);
        buf.writeLong(this.id);
    }

    private void encodeTag(Buf buf) {
        buf.reverseWrite((byte)this.codecVersion);
        buf.reverseWrite((byte)0);
        buf.reverseWrite((byte)0);
        buf.reverseWrite((byte)0);
    }

    private void encodeReverseTag(Buf buf) {
        buf.reverseWrite((byte)1);
        buf.reverseWrite((byte)0);
        buf.reverseWrite((byte)0);
        buf.reverseWrite((byte)0);
    }

    private void encodeSchemaVersion(Buf buf) {
        buf.writeInt(this.schemaVersion);
    }

    private void encodeSchemaVersion(int pos, Buf buf) {
        buf.writeInt(pos, this.schemaVersion);
    }

    public KeyValue encode(Object[] record) {
        KeyValue kv = new KeyValue(null, null);
        kv.setKey(this.encodeKey(record));
        kv.setValue(this.encodeValue(record));
        return kv;
    }

    private byte[] encodeKeyV1(Object[] record) {
        BufImpl keyBuf = new BufImpl(this.keyBufSize);
        this.encodeTag(keyBuf);
        this.encodePrefix(keyBuf);
        for (DingoSchema schema : this.schemas) {
            if (!schema.isKey()) continue;
            schema.encodeKey(keyBuf, record[schema.getIndex()]);
        }
        return keyBuf.getBytes();
    }

    private byte[] encodeKeyV2(Object[] record) {
        BufImpl keyBuf = new BufImpl(this.keyBufSize);
        this.encodeTag(keyBuf);
        this.encodePrefix(keyBuf);
        for (DingoSchema schema : this.schemas) {
            if (!schema.isKey()) continue;
            schema.encodeKeyV2(keyBuf, record[schema.getIndex()]);
        }
        return keyBuf.getBytes();
    }

    public byte[] encodeKey(Object[] record) {
        if (this.codecVersion == 1) {
            return this.encodeKeyV1(record);
        }
        return this.encodeKeyV2(record);
    }

    public byte[] encodeValue(Object[] record) {
        if (this.codecVersion == 1) {
            return this.encodeValueV1(record);
        }
        return this.encodeValueV2(record);
    }

    public byte[] encodeMinKeyPrefix() {
        BufImpl keyBuf = new BufImpl(9);
        this.encodePrefix(keyBuf);
        return keyBuf.getBytes();
    }

    public byte[] encodeMaxKeyPrefix() {
        if (this.id == Long.MAX_VALUE) {
            throw new RuntimeException("CommonId reach max! Cannot generate Max Key Prefix");
        }
        BufImpl keyBuf = new BufImpl(9);
        keyBuf.write((byte)114);
        keyBuf.writeLong(this.id + 1L);
        return keyBuf.getBytes();
    }

    public byte[] encodeKeyPrefix(Object[] record, int columnCount) {
        BufImpl keyBuf = new BufImpl(this.keyBufSize);
        this.encodePrefix(keyBuf);
        for (DingoSchema schema : this.schemas) {
            if (!schema.isKey()) continue;
            if (columnCount-- <= 0) break;
            schema.encodeKeyPrefix(keyBuf, record[schema.getIndex()]);
        }
        return keyBuf.getBytes();
    }

    public byte[] updateValueByRecord(byte[] buf, Object[] record, int[] columnIndexes) {
        BufImpl valueBuf = new BufImpl(buf);
        if (valueBuf.readInt() != this.schemaVersion) {
            throw new RuntimeException("Wrong Schema Version");
        }
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) continue;
            if (Arrays.binarySearch(columnIndexes, schema.getIndex()) < 0) {
                schema.skipValue(valueBuf);
                continue;
            }
            schema.encodeValue(valueBuf, record[schema.getIndex()]);
        }
        return valueBuf.getBytes();
    }

    public byte[] resetKeyPrefix(byte[] key, long prefix) {
        BufImpl buf = new BufImpl(key);
        buf.skip(1);
        buf.writeLong(prefix);
        return key;
    }

    public byte[] updateValueByColumns(byte[] buf, Object[] updateColumn, int[] columnIndexes) {
        return null;
    }

    public void setCodecVersion(int codecVersion) {
        this.codecVersion = codecVersion;
    }
}

