/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial;

import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.serial.Buf;
import io.dingodb.sdk.common.serial.BufImpl;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class RecordDecoder {
    private final int schemaVersion;
    private List<DingoSchema> schemas;
    private final long id;

    public RecordDecoder(int schemaVersion, List<DingoSchema> schemas, long id) {
        this.schemaVersion = schemaVersion;
        this.schemas = schemas;
        this.id = id;
    }

    private void checkPrefix(Buf buf) {
        buf.skip(1);
        long keyId = buf.readLong();
        if (keyId != this.id) {
            throw new RuntimeException("Invalid prefix id, codec prefix id: " + this.id + ", key prefix id " + keyId);
        }
    }

    private int checkTag(Buf buf) {
        byte codecVer = buf.reverseRead();
        if (codecVer > 2) {
            throw new RuntimeException("Invalid codec version, , key codec version " + codecVer);
        }
        buf.reverseSkip(3);
        return codecVer;
    }

    private void checkSchemaVersion(Buf buf) {
        int schemaVer = buf.readInt();
        if (schemaVer > this.schemaVersion) {
            throw new RuntimeException("Invalid schema version, schema version: " + this.schemaVersion + ", key schema version " + schemaVer);
        }
    }

    private int checkKeyValue(Buf keyBuf, Buf valueBuf) {
        int codecVer = this.checkTag(keyBuf);
        this.checkPrefix(keyBuf);
        this.checkSchemaVersion(valueBuf);
        return codecVer;
    }

    public Object[] decodeV1(KeyValue keyValue) {
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        this.checkKeyValue(keyBuf, valueBuf);
        Object[] record = new Object[this.schemas.size()];
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) {
                record[schema.getIndex()] = schema.decodeKey(keyBuf);
                continue;
            }
            if (valueBuf.isEnd()) continue;
            record[schema.getIndex()] = schema.decodeValue(valueBuf);
        }
        return record;
    }

    private Object[] decodeV1(KeyValue keyValue, int[] columnIndexes) {
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        this.checkKeyValue(keyBuf, valueBuf);
        Object[] record = new Object[columnIndexes.length];
        int i = 0;
        for (DingoSchema schema : this.schemas) {
            if (Arrays.binarySearch(columnIndexes, schema.getIndex()) < 0) {
                if (schema.isKey()) {
                    schema.skipKey(keyBuf);
                    continue;
                }
                if (valueBuf.isEnd()) continue;
                schema.skipValue(valueBuf);
                continue;
            }
            if (schema.isKey()) {
                record[i] = schema.decodeKey(keyBuf);
            } else if (!valueBuf.isEnd()) {
                record[i] = schema.decodeValue(valueBuf);
            }
            ++i;
        }
        return record;
    }

    public Object[] decodeV2(KeyValue keyValue) {
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        this.checkKeyValue(keyBuf, valueBuf);
        short cntNotNullCols = valueBuf.readShort();
        short cntNullCols = valueBuf.readShort();
        int totalColCnt = cntNotNullCols + cntNullCols;
        int idsPos = 8;
        int offsetPos = idsPos + 2 * totalColCnt;
        int dataPos = offsetPos + 4 * totalColCnt;
        TreeMap<Short, Integer> idOffsetMap = new TreeMap<Short, Integer>();
        for (int i = 0; i < totalColCnt; ++i) {
            short id = valueBuf.readShortAt(idsPos);
            int offset = valueBuf.readIntAt(offsetPos);
            idOffsetMap.put(id, offset);
            idsPos += 2;
            offsetPos += 4;
        }
        valueBuf.setForwardOffset(dataPos);
        Object[] record = new Object[this.schemas.size()];
        for (DingoSchema schema : this.schemas) {
            if (schema.isKey()) {
                record[schema.getIndex()] = schema.decodeKeyV2(keyBuf);
                continue;
            }
            if (valueBuf.isEnd()) continue;
            int index = schema.getIndex();
            if ((Integer)idOffsetMap.get((short)index) == -1) {
                record[index] = null;
                continue;
            }
            record[index] = schema.decodeValueV2(valueBuf);
        }
        return record;
    }

    private Object[] decodeV2(KeyValue keyValue, int[] columnIndexes) {
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        this.checkKeyValue(keyBuf, valueBuf);
        short cntNotNullCols = valueBuf.readShort();
        short cntNullCols = valueBuf.readShort();
        int totalColCnt = cntNotNullCols + cntNullCols;
        int idsPos = 8;
        int offsetPos = idsPos + 2 * totalColCnt;
        int dataPos = offsetPos + 4 * totalColCnt;
        TreeMap<Short, Integer> idOffsetMap = new TreeMap<Short, Integer>();
        for (int i = 0; i < totalColCnt; ++i) {
            short id = valueBuf.readShortAt(idsPos);
            int offset = valueBuf.readIntAt(offsetPos);
            idOffsetMap.put(id, offset);
            idsPos += 2;
            offsetPos += 4;
        }
        valueBuf.setForwardOffset(dataPos);
        Object[] record = new Object[columnIndexes.length];
        int i = 0;
        for (DingoSchema schema : this.schemas) {
            if (Arrays.binarySearch(columnIndexes, schema.getIndex()) < 0) {
                if (schema.isKey()) {
                    schema.skipKeyV2(keyBuf);
                    continue;
                }
                if (valueBuf.isEnd() || (Integer)idOffsetMap.get((short)schema.getIndex()) == -1) continue;
                schema.skipValueV2(valueBuf);
                continue;
            }
            if (schema.isKey()) {
                record[i] = schema.decodeKeyV2(keyBuf);
            } else if (!valueBuf.isEnd()) {
                record[i] = (Integer)idOffsetMap.get((short)schema.getIndex()) == -1 ? null : schema.decodeValueV2(valueBuf);
            }
            ++i;
        }
        return record;
    }

    public Object[] decode(KeyValue keyValue) {
        BufImpl valueBuf;
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        int codecVer = this.checkKeyValue(keyBuf, valueBuf = new BufImpl(keyValue.getValue()));
        if (codecVer <= 1) {
            return this.decodeV1(keyValue);
        }
        return this.decodeV2(keyValue);
    }

    public Object[] decode(KeyValue keyValue, int[] columnIndexes) {
        BufImpl valueBuf;
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        int codecVer = this.checkKeyValue(keyBuf, valueBuf = new BufImpl(keyValue.getValue()));
        if (codecVer <= 1) {
            return this.decodeV1(keyValue, columnIndexes);
        }
        return this.decodeV2(keyValue, columnIndexes);
    }

    public Object[] decodeKeyPrefix(byte[] keyPrefix) {
        BufImpl keyPrefixBuf = new BufImpl(keyPrefix);
        keyPrefixBuf.skip(1);
        if (keyPrefixBuf.readLong() != this.id) {
            throw new RuntimeException("Wrong Common Id");
        }
        Object[] record = new Object[this.schemas.size()];
        for (DingoSchema schema : this.schemas) {
            if (keyPrefixBuf.isEnd()) break;
            if (!schema.isKey()) continue;
            record[schema.getIndex()] = schema.decodeKeyPrefix(keyPrefixBuf);
        }
        return record;
    }

    private Object[] decodeValueV1(KeyValue keyValue, int[] columnIndexes) {
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        if (valueBuf.readInt() > this.schemaVersion) {
            throw new RuntimeException("Wrong Schema Version");
        }
        Object[] record = new Object[this.schemas.size()];
        for (DingoSchema schema : this.schemas) {
            if (valueBuf.isEnd()) break;
            if (schema.isKey()) continue;
            if (Arrays.binarySearch(columnIndexes, schema.getIndex()) < 0) {
                schema.skipValue(valueBuf);
                continue;
            }
            record[schema.getIndex()] = schema.decodeValue(valueBuf);
        }
        return record;
    }

    private Object[] decodeValueV2(KeyValue keyValue, int[] columnIndexes) {
        BufImpl valueBuf = new BufImpl(keyValue.getValue());
        if (valueBuf.readInt() > this.schemaVersion) {
            throw new RuntimeException("Wrong Schema Version");
        }
        short cntNotNullCols = valueBuf.readShort();
        short cntNullCols = valueBuf.readShort();
        int totalColCnt = cntNotNullCols + cntNullCols;
        int idsPos = 8;
        int offsetPos = idsPos + 2 * totalColCnt;
        int dataPos = offsetPos + 4 * totalColCnt;
        HashMap<Short, Integer> idOffsetMap = new HashMap<Short, Integer>();
        for (int i = 0; i < totalColCnt; ++i) {
            short id = valueBuf.readShortAt(idsPos);
            int offset = valueBuf.readIntAt(offsetPos);
            idOffsetMap.put(id, offset);
            idsPos += 2;
            offsetPos += 4;
        }
        valueBuf.setForwardOffset(dataPos);
        Object[] record = new Object[this.schemas.size()];
        for (DingoSchema schema : this.schemas) {
            if (valueBuf.isEnd()) break;
            if (schema.isKey()) continue;
            if (Arrays.binarySearch(columnIndexes, schema.getIndex()) < 0) {
                if ((Integer)idOffsetMap.get((short)schema.getIndex()) == -1) continue;
                schema.skipValueV2(valueBuf);
                continue;
            }
            record[schema.getIndex()] = schema.decodeValueV2(valueBuf);
        }
        return record;
    }

    public Object[] decodeValue(KeyValue keyValue, int[] columnIndexes) {
        BufImpl valueBuf;
        BufImpl keyBuf = new BufImpl(keyValue.getKey());
        int codecVer = this.checkKeyValue(keyBuf, valueBuf = new BufImpl(keyValue.getValue()));
        if (codecVer == 1) {
            return this.decodeValueV1(keyValue, columnIndexes);
        }
        return this.decodeValueV2(keyValue, columnIndexes);
    }
}

