/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial;

public class MyDecimal {
    private static final int MaxWordBufLen = 9;
    private static final int wordMax = 999999999;
    private static final int digMask = 100000000;
    private static final int digitsPerWord = 9;
    private static final int wordSize = 4;
    private static final int wordBufLen = 9;
    private static final int MaxDecimalScale = 30;
    private static final int div9Len = 128;
    private static final int[] div9 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14};
    private static final int[] dig2bytes = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};
    private static int[] powers10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private int precision;
    private int scale;
    private int digitsInt = 0;
    private int digitsFrac = 0;
    private int resultFrac = 0;
    private boolean negative = false;
    private final int[] wordBuf = new int[9];

    private int digitsToWords(int digits) {
        if (digits + 9 - 1 >= 0 && digits + 9 - 1 < 128) {
            return div9[digits + 9 - 1];
        }
        return (digits + 9 - 1) / 9;
    }

    private int countLeadingZeroes(int i, int word) {
        int leading = 0;
        while (word < powers10[i]) {
            --i;
            ++leading;
        }
        return leading;
    }

    private DecimalContext removeLeadingZeros() {
        DecimalContext decimalInProcess = new DecimalContext();
        decimalInProcess.digitsIntLocal = this.digitsInt;
        int i = (decimalInProcess.digitsIntLocal - 1) % 9 + 1;
        while (decimalInProcess.digitsIntLocal > 0 && this.wordBuf[decimalInProcess.wordIdx] == 0) {
            decimalInProcess.digitsIntLocal -= i;
            i = 9;
            ++decimalInProcess.wordIdx;
        }
        decimalInProcess.digitsIntLocal = decimalInProcess.digitsIntLocal > 0 ? (decimalInProcess.digitsIntLocal -= this.countLeadingZeroes((decimalInProcess.digitsIntLocal - 1) % 9, this.wordBuf[decimalInProcess.wordIdx])) : 0;
        return decimalInProcess;
    }

    private DecimalContext DecimalBinSize(int precision, int frac) {
        DecimalContext decimalContext = new DecimalContext();
        int digitsInt = precision - frac;
        int wordsInt = digitsInt / 9;
        int wordsFrac = frac / 9;
        int xInt = digitsInt - wordsInt * 9;
        int xFrac = frac - wordsFrac * 9;
        if (xInt < 0 || xInt >= dig2bytes.length || xFrac < 0 || xFrac >= dig2bytes.length) {
            decimalContext.decimalBinSize = 0;
            decimalContext.err = DecimalError.ErrBadNumber;
            return decimalContext;
        }
        decimalContext.decimalBinSize = wordsInt * 4 + dig2bytes[xInt] + wordsFrac * 4 + dig2bytes[xFrac];
        decimalContext.err = DecimalError.None;
        return decimalContext;
    }

    private int readWord(byte[] b, int index, int size) {
        int x = 0;
        switch (size) {
            case 1: {
                x = b[index];
                break;
            }
            case 2: {
                int a1 = b[index] << 8;
                int a2 = b[index + 1] & 0xFF;
                x = a1 + a2;
                break;
            }
            case 3: {
                if ((b[index] & 0x80) > 0) {
                    x = 0xFF000000 | b[index] << 16 & 0xFFFFFF | b[index + 1] << 8 & 0xFFFF | b[index + 2] & 0xFF;
                    break;
                }
                x = b[index] << 16 & 0xFFFFFF | b[index + 1] << 8 & 0xFFFF | b[index + 2] & 0xFF;
                break;
            }
            case 4: {
                x = (b[index + 3] & 0xFF) + (b[index + 2] << 8 & 0xFFFF) + (b[index + 1] << 16 & 0xFFFFFF) + (b[index] << 24 & 0xFFFFFFFF);
            }
        }
        return x;
    }

    private void writeWord(byte[] b, int start, int word, int size) {
        int v = word;
        switch (size) {
            case 1: {
                b[start] = (byte)word;
                break;
            }
            case 2: {
                b[start] = (byte)(v >> 8);
                b[start + 1] = (byte)v;
                break;
            }
            case 3: {
                b[start] = (byte)(v >> 16);
                b[start + 1] = (byte)(v >> 8);
                b[start + 2] = (byte)v;
                break;
            }
            case 4: {
                b[start] = (byte)(v >> 24);
                b[start + 1] = (byte)(v >> 16);
                b[start + 2] = (byte)(v >> 8);
                b[start + 3] = (byte)v;
            }
        }
    }

    private DecimalContext fixWordCntError(int wordsInt, int wordsFrac) {
        DecimalContext decimalContext = new DecimalContext();
        if (wordsInt + wordsFrac > 9) {
            if (wordsInt > 9) {
                decimalContext.setNewWordInt(9);
                decimalContext.setNewWordFrac(0);
                decimalContext.setErr(DecimalError.ErrOverflow);
                return decimalContext;
            }
            decimalContext.setNewWordInt(wordsInt);
            decimalContext.setNewWordFrac(9 - wordsInt);
            decimalContext.setErr(DecimalError.ErrTruncate);
            return decimalContext;
        }
        decimalContext.setNewWordInt(wordsInt);
        decimalContext.setNewWordFrac(wordsFrac);
        decimalContext.setErr(DecimalError.None);
        return decimalContext;
    }

    private String dealWithE(String string) {
        int ePos = string.toLowerCase().indexOf("e");
        int eVal = Integer.parseInt(string.substring(ePos + 1, string.length()));
        int negative = -1;
        if (string.charAt(0) == '-') {
            negative = 1;
        } else if (string.charAt(0) == '+') {
            negative = 0;
        }
        int valueStart = negative == -1 ? 0 : 1;
        boolean hasPoint = string.contains(".");
        if (hasPoint) {
            int pointPos = string.indexOf(".");
            String intPartString = string.substring(valueStart, pointPos);
            String fracPartString = string.substring(pointPos + 1, ePos);
            StringBuilder builder = new StringBuilder();
            if (negative == 1) {
                builder.append("-");
            } else if (negative == 0) {
                builder.append("+");
            }
            int newPointPos = pointPos + eVal;
            if (newPointPos < 0) {
                int appendingZeroCount = Math.abs(newPointPos);
                if (negative != -1 && newPointPos < 0) {
                    ++appendingZeroCount;
                }
                return builder.append("0.").append(String.valueOf('0').repeat(appendingZeroCount)).append(intPartString).append(fracPartString).toString();
            }
            if (newPointPos > intPartString.length() + fracPartString.length()) {
                int appendingZeroCount = newPointPos - intPartString.length() - fracPartString.length();
                if (negative != -1) {
                    --appendingZeroCount;
                }
                return builder.append(intPartString).append(fracPartString).append(String.valueOf('0').repeat(appendingZeroCount)).toString();
            }
            return builder.append(intPartString).append(fracPartString).insert(newPointPos, '.').toString();
        }
        StringBuilder builder = new StringBuilder();
        if (negative == 1) {
            builder.append("-");
        } else if (negative == 0) {
            builder.append("+");
        }
        int newPointPos = eVal;
        if (newPointPos < 0) {
            int appendingZeroCount = Math.abs(newPointPos);
            return builder.append(String.valueOf('0').repeat(Math.abs(newPointPos))).append(string).toString();
        }
        if (newPointPos > string.length()) {
            int appendingZeroCount = newPointPos - string.length();
            return builder.append(string).append(String.valueOf('0').repeat(Math.abs(newPointPos))).toString();
        }
        int finalPointPos = (negative == -1 ? 0 : 1) + newPointPos;
        return builder.append(string).insert(finalPointPos, '.').toString();
    }

    public MyDecimal(String string, int prec, int scal) {
        int strIdx;
        string = ((String)string).trim();
        this.precision = prec;
        this.scale = scal;
        if (((String)string).isEmpty()) {
            throw new IllegalArgumentException("Decimal type: Empty string is not allowed.");
        }
        if (((String)string).contains("e") || ((String)string).contains("E")) {
            string = this.dealWithE((String)string);
        }
        int curStringPos = 0;
        char flag = ((String)string).charAt(curStringPos);
        switch (flag) {
            case '-': {
                this.negative = true;
            }
            case '+': {
                ++curStringPos;
            }
        }
        for (strIdx = curStringPos; strIdx < ((String)string).length() && Character.isDigit(((String)string).charAt(strIdx)); ++strIdx) {
        }
        int digitsIntLocal = strIdx - curStringPos;
        int digitsFracLocal = 0;
        int endIdx = 0;
        if (strIdx < ((String)string).length() && ((String)string).charAt(strIdx) == '.') {
            for (endIdx = strIdx + 1; endIdx < ((String)string).length() && Character.isDigit(((String)string).charAt(endIdx)); ++endIdx) {
            }
            digitsFracLocal = endIdx - strIdx - 1;
        } else {
            endIdx = strIdx;
        }
        if (digitsIntLocal + digitsFracLocal == 0) {
            throw new IllegalArgumentException("Decimal type: No digits in string.");
        }
        if (digitsFracLocal != 0 && scal < digitsFracLocal) {
            int lastDigitPos = 1 - (this.negative ? 1 : 0);
            int lastDigit = Integer.parseInt(String.valueOf(((String)string).charAt(digitsIntLocal + digitsFracLocal - lastDigitPos)));
            lastDigit = lastDigit < 5 ? lastDigit : lastDigit + 1;
            string = ((String)string).substring(0, digitsIntLocal + digitsFracLocal - lastDigitPos) + lastDigit;
            digitsFracLocal = scal;
        }
        int wordsInt = this.digitsToWords(digitsIntLocal);
        int wordsFrac = this.digitsToWords(digitsFracLocal);
        DecimalContext decimalContext = this.fixWordCntError(wordsInt, wordsFrac);
        wordsInt = decimalContext.getNewWordInt();
        wordsFrac = decimalContext.getNewWordFrac();
        if (decimalContext.getErr() != DecimalError.None) {
            digitsFracLocal = wordsFrac * 9;
            if (decimalContext.getErr() == DecimalError.ErrOverflow) {
                digitsIntLocal = wordsInt * 9;
            }
        }
        this.digitsInt = digitsIntLocal;
        this.digitsFrac = digitsFracLocal;
        int wordIdx = wordsInt;
        int strIdxTmp = strIdx;
        int word = 0;
        int innerIdx = 0;
        while (digitsIntLocal > 0) {
            --digitsIntLocal;
            word += (((String)string).charAt(--strIdx) - 48) * powers10[innerIdx];
            if (++innerIdx != 9) continue;
            this.wordBuf[--wordIdx] = word;
            word = 0;
            innerIdx = 0;
        }
        if (innerIdx != 0) {
            this.wordBuf[--wordIdx] = word;
        }
        wordIdx = wordsInt;
        strIdx = strIdxTmp;
        word = 0;
        innerIdx = 0;
        while (digitsFracLocal > 0) {
            --digitsFracLocal;
            word = ((String)string).charAt(++strIdx) - 48 + word * 10;
            if (++innerIdx != 9) continue;
            this.wordBuf[wordIdx] = word;
            ++wordIdx;
            word = 0;
            innerIdx = 0;
        }
        if (innerIdx != 0) {
            this.wordBuf[wordIdx] = word * powers10[9 - innerIdx];
        }
        if (endIdx + 1 <= ((String)string).length()) {
            throw new IllegalArgumentException("Decimal type: String contained invalid characters or E at the tail.");
        }
        boolean allZero = true;
        for (int i = 0; i < 9; ++i) {
            if (this.wordBuf[i] == 0) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            this.negative = false;
        }
        this.resultFrac = this.digitsFrac;
    }

    private byte[] writeBin(int precision, int frac) {
        int x;
        if (precision > 81 || precision < 0 || frac > 30 || frac < 0) {
            throw new IllegalArgumentException("Decimal type: Precision or frac out of range.");
        }
        int mask = 0;
        if (this.negative) {
            mask = -1;
        }
        int digitsIntLocal = precision - frac;
        int wordsInt = digitsIntLocal / 9;
        int leadingDigits = digitsIntLocal - wordsInt * 9;
        int wordsFracLocal = frac / 9;
        int trailingDigits = frac - wordsFracLocal * 9;
        int wordsFracFrom = this.digitsFrac / 9;
        int trailingDigitsFrom = this.digitsFrac - wordsFracFrom * 9;
        int intSize = wordsInt * 4 + dig2bytes[leadingDigits];
        int fracSize = wordsFracLocal * 4 + dig2bytes[trailingDigits];
        int fracSizeFrom = wordsFracFrom * 4 + dig2bytes[trailingDigitsFrom];
        int originIntSize = intSize;
        int originFracSize = fracSize;
        byte[] buf = new byte[intSize + fracSize];
        int binIdx = 0;
        DecimalContext decimalContext = this.removeLeadingZeros();
        int wordIdxFrom = decimalContext.wordIdx;
        int digitsIntFrom = decimalContext.digitsIntLocal;
        if (digitsIntFrom + fracSizeFrom == 0) {
            mask = 0;
            digitsIntLocal = 1;
        }
        int wordsIntFrom = digitsIntFrom / 9;
        int leadingDigitsFrom = digitsIntFrom - wordsIntFrom * 9;
        int iSizeFrom = wordsIntFrom * 4 + dig2bytes[leadingDigitsFrom];
        if (digitsIntLocal < digitsIntFrom) {
            wordIdxFrom += wordsIntFrom - wordsInt;
            if (leadingDigitsFrom > 0) {
                ++wordIdxFrom;
            }
            if (leadingDigits > 0) {
                --wordIdxFrom;
            }
            wordsIntFrom = wordsInt;
            leadingDigitsFrom = leadingDigits;
            throw new RuntimeException("Decimal type: overflow.");
        }
        if (intSize > iSizeFrom) {
            while (intSize > iSizeFrom) {
                --intSize;
                buf[binIdx] = (byte)mask;
                ++binIdx;
            }
        }
        if (fracSize < fracSizeFrom || fracSize == fracSizeFrom && (trailingDigits <= trailingDigitsFrom || wordsFracLocal <= wordsFracFrom)) {
            if (fracSize < fracSizeFrom || fracSize == fracSizeFrom && trailingDigits < trailingDigitsFrom || fracSize == fracSizeFrom && wordsFracLocal < wordsFracFrom) {
                throw new RuntimeException("Decimal type: truncated.");
            }
            wordsFracFrom = wordsFracLocal;
            trailingDigitsFrom = trailingDigits;
        } else if (fracSize > fracSizeFrom && trailingDigitsFrom > 0) {
            if (wordsFracLocal == wordsFracFrom) {
                trailingDigitsFrom = trailingDigits;
                fracSize = fracSizeFrom;
            } else {
                ++wordsFracFrom;
                trailingDigitsFrom = 0;
            }
        }
        if (leadingDigitsFrom > 0) {
            int i = dig2bytes[leadingDigitsFrom];
            x = this.wordBuf[wordIdxFrom] % powers10[leadingDigitsFrom] ^ mask;
            ++wordIdxFrom;
            this.writeWord(buf, binIdx, x, i);
            binIdx += i;
        }
        int stop = wordIdxFrom + wordsIntFrom + wordsFracFrom;
        while (wordIdxFrom < stop) {
            x = this.wordBuf[wordIdxFrom] ^ mask;
            ++wordIdxFrom;
            this.writeWord(buf, binIdx, x, 4);
            binIdx += 4;
        }
        if (trailingDigitsFrom > 0) {
            int x2 = 0;
            int i = dig2bytes[trailingDigitsFrom];
            int lim = trailingDigits;
            if (wordsFracFrom < wordsFracLocal) {
                lim = 9;
            }
            while (trailingDigitsFrom < lim && dig2bytes[trailingDigitsFrom] == i) {
                ++trailingDigitsFrom;
            }
            x2 = this.wordBuf[wordIdxFrom] / powers10[9 - trailingDigitsFrom] ^ mask;
            this.writeWord(buf, binIdx, x2, i);
            binIdx += i;
        }
        if (fracSize > fracSizeFrom) {
            int binIdxEnd = originIntSize + originFracSize;
            while (fracSize > fracSizeFrom && binIdx < binIdxEnd) {
                --fracSize;
                buf[binIdx] = (byte)mask;
                ++binIdx;
            }
        }
        buf[0] = (byte)(buf[0] ^ 0x80);
        return buf;
    }

    public byte[] toBin() {
        return this.toBin(this.precision, this.scale);
    }

    public byte[] toBin(int precision, int frac) {
        return this.writeBin(precision, frac);
    }

    public void FromBin(byte[] bin, int precision, int frac) {
        int x;
        int i;
        int binSize = 0;
        if (bin.length == 0) {
            throw new RuntimeException("Decimal type: bin length is zero");
        }
        int digitsIntLocal = precision - frac;
        int wordsInt = digitsIntLocal / 9;
        int leadingDigits = digitsIntLocal - wordsInt * 9;
        int wordsFrac = frac / 9;
        int trailingDigits = frac - wordsFrac * 9;
        int wordsIntTo = wordsInt;
        if (leadingDigits > 0) {
            ++wordsIntTo;
        }
        int wordsFracTo = wordsFrac;
        if (trailingDigits > 0) {
            ++wordsFracTo;
        }
        int binIdx = 0;
        int mask = -1;
        if ((bin[binIdx] & 0x80) > 0) {
            mask = 0;
        }
        DecimalContext decimalContext = this.DecimalBinSize(precision, frac);
        binSize = decimalContext.decimalBinSize;
        DecimalError err = decimalContext.getErr();
        if (err != DecimalError.None) {
            throw new RuntimeException("Decimal type: Bad number.");
        }
        if (binSize < 0 || binSize > 40) {
            throw new RuntimeException("Decimal type: Bad number.");
        }
        bin[0] = (byte)(bin[0] ^ 0x80);
        int oldWordsIntTo = wordsIntTo;
        DecimalContext decimalInProcess = this.fixWordCntError(wordsIntTo, wordsFracTo);
        wordsIntTo = decimalInProcess.newWordInt;
        wordsFracTo = decimalInProcess.newWordFrac;
        DecimalError err2 = decimalContext.getErr();
        if (err != DecimalError.None) {
            if (wordsIntTo < oldWordsIntTo) {
                binIdx += dig2bytes[leadingDigits] + (wordsInt - wordsIntTo) * 4;
            } else {
                trailingDigits = 0;
                wordsFrac = wordsFracTo;
            }
        }
        this.negative = mask != 0;
        this.digitsInt = wordsInt * 9 + leadingDigits;
        this.digitsFrac = wordsFrac * 9 + trailingDigits;
        int wordIdx = 0;
        if (leadingDigits > 0) {
            i = dig2bytes[leadingDigits];
            x = this.readWord(bin, binIdx, i);
            binIdx += i;
            this.wordBuf[wordIdx] = x ^ mask;
            if ((long)this.wordBuf[wordIdx] >= (long)powers10[leadingDigits + 1]) {
                throw new RuntimeException("Decimal type: Bad number.");
            }
            if (wordIdx > 0 || this.wordBuf[wordIdx] != 0) {
                ++wordIdx;
            } else {
                this.digitsInt -= (byte)leadingDigits;
            }
        }
        int stop = binIdx + wordsInt * 4;
        while (binIdx < stop) {
            this.wordBuf[wordIdx] = this.readWord(bin, binIdx, 4) ^ mask;
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new RuntimeException("Decimal type: bad number.");
            }
            if (wordIdx > 0 || this.wordBuf[wordIdx] != 0) {
                ++wordIdx;
            } else {
                this.digitsInt -= 9;
            }
            binIdx += 4;
        }
        stop = binIdx + wordsFrac * 4;
        while (binIdx < stop) {
            this.wordBuf[wordIdx] = this.readWord(bin, binIdx, 4) ^ mask;
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new RuntimeException("Decimal type: bad number.");
            }
            ++wordIdx;
            binIdx += 4;
        }
        if (trailingDigits > 0) {
            i = dig2bytes[trailingDigits];
            x = this.readWord(bin, binIdx, i);
            this.wordBuf[wordIdx] = (x ^ mask) * powers10[9 - trailingDigits];
            if (this.wordBuf[wordIdx] > 999999999) {
                throw new RuntimeException("Decimal type: Bad number.");
            }
        }
        if (this.digitsInt == 0 && this.digitsFrac == 0) {
            throw new RuntimeException("Decimal type: bad number.");
        }
        this.resultFrac = frac;
    }

    public MyDecimal(byte[] buf, int prec, int scal) {
        this.precision = prec;
        this.scale = scal;
        this.FromBin(buf, this.precision, this.scale);
    }

    private int stringSize() {
        return this.digitsInt + this.digitsFrac + 3;
    }

    public String decimalToString() {
        int digitsIntLen;
        int digitsFracLocal = this.digitsFrac;
        DecimalContext decimalInProcess = this.removeLeadingZeros();
        int wordStartIdx = decimalInProcess.wordIdx;
        int digitsIntLocal = decimalInProcess.digitsIntLocal;
        if (digitsIntLocal + digitsFracLocal == 0) {
            digitsIntLocal = 1;
            wordStartIdx = 0;
        }
        if ((digitsIntLen = digitsIntLocal) == 0) {
            digitsIntLen = 1;
        }
        int digitsFracLen = digitsFracLocal;
        int length = digitsIntLen + digitsFracLen;
        if (this.negative) {
            ++length;
        }
        if (digitsFracLocal > 0) {
            ++length;
        }
        byte[] str = new byte[length];
        int strIdx = 0;
        if (this.negative) {
            str[strIdx] = 45;
            ++strIdx;
        }
        int fill = 0;
        if (digitsFracLocal > 0) {
            int fracIdx = strIdx + digitsIntLen;
            fill = digitsFracLen - digitsFracLocal;
            int wordIdx = wordStartIdx + this.digitsToWords(digitsIntLocal);
            str[fracIdx] = 46;
            ++fracIdx;
            while (digitsFracLocal > 0) {
                int x = this.wordBuf[wordIdx];
                ++wordIdx;
                for (int i = Math.min(digitsFracLocal, 9); i > 0; --i) {
                    int y = x / 100000000;
                    str[fracIdx] = (byte)((byte)y + 48);
                    ++fracIdx;
                    x -= y * 100000000;
                    x *= 10;
                }
                digitsFracLocal -= 9;
            }
            while (fill > 0) {
                str[fracIdx] = 48;
                ++fracIdx;
                --fill;
            }
        }
        fill = digitsIntLen - digitsIntLocal;
        if (digitsIntLocal == 0) {
            --fill;
        }
        while (fill > 0) {
            str[strIdx] = 48;
            ++strIdx;
            --fill;
        }
        if (digitsIntLocal > 0) {
            strIdx += digitsIntLocal;
            int wordIdx = wordStartIdx + this.digitsToWords(digitsIntLocal);
            while (digitsIntLocal > 0) {
                int x = this.wordBuf[--wordIdx];
                for (int i = Math.min(digitsIntLocal, 9); i > 0; --i) {
                    int y = x / 10;
                    str[--strIdx] = (byte)(48 + (byte)(x - y * 10));
                    x = y;
                }
                digitsIntLocal -= 9;
            }
        } else {
            str[strIdx] = 48;
        }
        return new String(str);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getDigitsInt() {
        return this.digitsInt;
    }

    public void setDigitsInt(int digitsInt) {
        this.digitsInt = digitsInt;
    }

    public int getDigitsFrac() {
        return this.digitsFrac;
    }

    public void setDigitsFrac(int digitsFrac) {
        this.digitsFrac = digitsFrac;
    }

    public int getResultFrac() {
        return this.resultFrac;
    }

    public void setResultFrac(int resultFrac) {
        this.resultFrac = resultFrac;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public int[] getWordBuf() {
        return this.wordBuf;
    }

    private static class DecimalContext {
        private int start;
        private int end;
        private int sum;
        private int newCarry;
        private int wordIdx;
        private int digitsIntLocal;
        private int newWordInt;
        private int newWordFrac;
        private int decimalBinSize;
        private DecimalError err;

        DecimalContext() {
            this.start = 0;
            this.end = 0;
            this.sum = 0;
            this.newCarry = 0;
            this.wordIdx = 0;
            this.digitsIntLocal = 0;
            this.newWordInt = 0;
            this.newWordFrac = 0;
            this.decimalBinSize = 0;
            this.err = DecimalError.None;
        }

        public DecimalContext(int start, int end, int sum, int newCarry, int wordIdx, int digitsIntLocal, int newWordInt, int newWordFrac, int decimalBinSize, DecimalError err) {
            this.start = start;
            this.end = end;
            this.sum = sum;
            this.newCarry = newCarry;
            this.wordIdx = wordIdx;
            this.digitsIntLocal = digitsIntLocal;
            this.newWordInt = newWordInt;
            this.newWordFrac = newWordFrac;
            this.decimalBinSize = decimalBinSize;
            this.err = err;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getSum() {
            return this.sum;
        }

        public int getNewCarry() {
            return this.newCarry;
        }

        public int getWordIdx() {
            return this.wordIdx;
        }

        public int getDigitsIntLocal() {
            return this.digitsIntLocal;
        }

        public int getNewWordInt() {
            return this.newWordInt;
        }

        public int getNewWordFrac() {
            return this.newWordFrac;
        }

        public int getDecimalBinSize() {
            return this.decimalBinSize;
        }

        public DecimalError getErr() {
            return this.err;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void setSum(int sum) {
            this.sum = sum;
        }

        public void setNewCarry(int newCarry) {
            this.newCarry = newCarry;
        }

        public void setWordIdx(int wordIdx) {
            this.wordIdx = wordIdx;
        }

        public void setDigitsIntLocal(int digitsIntLocal) {
            this.digitsIntLocal = digitsIntLocal;
        }

        public void setNewWordInt(int newWordInt) {
            this.newWordInt = newWordInt;
        }

        public void setNewWordFrac(int newWordFrac) {
            this.newWordFrac = newWordFrac;
        }

        public void setDecimalBinSize(int decimalBinSize) {
            this.decimalBinSize = decimalBinSize;
        }

        public void setErr(DecimalError err) {
            this.err = err;
        }
    }

    private static enum DecimalError {
        None,
        ErrOverflow,
        ErrTruncate,
        ErrBadNumber;

    }
}

