/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.serial;

import io.dingodb.sdk.common.serial.Buf;

public class BufImpl
implements Buf {
    private byte[] buf;
    private int forwardPos;
    private int reversePos;

    private void setForwardPos(int pos) {
        this.forwardPos = pos;
    }

    public BufImpl(int bufSize) {
        this.buf = new byte[bufSize];
        this.forwardPos = 0;
        this.reversePos = bufSize - 1;
    }

    public BufImpl(byte[] keyBuf) {
        this.buf = keyBuf;
        this.forwardPos = 0;
        this.reversePos = keyBuf.length - 1;
    }

    public BufImpl(int bufSize, int dataPos) {
        this.buf = new byte[bufSize];
        this.forwardPos = dataPos;
        this.reversePos = bufSize - 1;
    }

    @Override
    public void write(byte b) {
        this.buf[this.forwardPos++] = b;
    }

    @Override
    public void write(int pos, byte b) {
        this.buf[pos] = b;
    }

    @Override
    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.forwardPos, b.length);
        this.forwardPos += b.length;
    }

    @Override
    public void write(int pos, byte[] b) {
        System.arraycopy(b, 0, this.buf, pos, b.length);
    }

    @Override
    public void write(byte[] b, int pos, int length) {
        System.arraycopy(b, pos, this.buf, this.forwardPos, length);
        this.forwardPos += length;
    }

    @Override
    public void write(int srcPos, byte[] b, int pos, int length) {
        System.arraycopy(b, pos, this.buf, srcPos, length);
    }

    @Override
    public void writeShort(int pos, short i) {
        this.buf[pos] = (byte)(i >>> 8);
        this.buf[pos + 1] = (byte)i;
    }

    @Override
    public void writeInt(int i) {
        this.buf[this.forwardPos++] = (byte)(i >>> 24);
        this.buf[this.forwardPos++] = (byte)(i >>> 16);
        this.buf[this.forwardPos++] = (byte)(i >>> 8);
        this.buf[this.forwardPos++] = (byte)i;
    }

    @Override
    public void writeInt(int pos, int i) {
        this.buf[pos] = (byte)(i >>> 24);
        this.buf[pos + 1] = (byte)(i >>> 16);
        this.buf[pos + 2] = (byte)(i >>> 8);
        this.buf[pos + 3] = (byte)i;
    }

    @Override
    public void writeLong(long l) {
        this.buf[this.forwardPos++] = (byte)(l >>> 56);
        this.buf[this.forwardPos++] = (byte)(l >>> 48);
        this.buf[this.forwardPos++] = (byte)(l >>> 40);
        this.buf[this.forwardPos++] = (byte)(l >>> 32);
        this.buf[this.forwardPos++] = (byte)(l >>> 24);
        this.buf[this.forwardPos++] = (byte)(l >>> 16);
        this.buf[this.forwardPos++] = (byte)(l >>> 8);
        this.buf[this.forwardPos++] = (byte)l;
    }

    @Override
    public void writeLong(int pos, long l) {
        this.buf[pos] = (byte)(l >>> 56);
        this.buf[pos + 1] = (byte)(l >>> 48);
        this.buf[pos + 2] = (byte)(l >>> 40);
        this.buf[pos + 3] = (byte)(l >>> 32);
        this.buf[pos + 4] = (byte)(l >>> 24);
        this.buf[pos + 5] = (byte)(l >>> 16);
        this.buf[pos + 6] = (byte)(l >>> 8);
        this.buf[pos + 7] = (byte)l;
    }

    @Override
    public byte peek() {
        return this.buf[this.forwardPos];
    }

    @Override
    public int peekInt() {
        return (this.buf[this.forwardPos] & 0xFF) << 24 | (this.buf[this.forwardPos + 1] & 0xFF) << 16 | (this.buf[this.forwardPos + 2] & 0xFF) << 8 | this.buf[this.forwardPos + 3] & 0xFF;
    }

    @Override
    public long peekLong() {
        long l = this.buf[this.forwardPos] & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(this.buf[this.forwardPos + i + 1] & 0xFF);
        }
        return l;
    }

    @Override
    public byte read() {
        return this.buf[this.forwardPos++];
    }

    @Override
    public byte readAt(int pos) {
        return this.buf[pos];
    }

    @Override
    public byte[] read(int length) {
        byte[] b = new byte[length];
        System.arraycopy(this.buf, this.forwardPos, b, 0, length);
        this.forwardPos += length;
        return b;
    }

    @Override
    public byte[] readAt(int pos, int length) {
        byte[] b = new byte[length];
        System.arraycopy(this.buf, pos, b, 0, length);
        return b;
    }

    @Override
    public void read(byte[] b, int pos, int length) {
        System.arraycopy(this.buf, this.forwardPos, b, pos, length);
        this.forwardPos += length;
    }

    @Override
    public void readAt(int srcPos, byte[] b, int pos, int length) {
        System.arraycopy(this.buf, srcPos, b, pos, length);
    }

    @Override
    public short readShortAt(int pos) {
        return (short)((this.buf[pos] & 0xFF) << 8 | this.buf[pos + 1] & 0xFF);
    }

    @Override
    public short readShort() {
        return (short)((this.buf[this.forwardPos++] & 0xFF) << 8 | this.buf[this.forwardPos++] & 0xFF);
    }

    @Override
    public int readInt() {
        return (this.buf[this.forwardPos++] & 0xFF) << 24 | (this.buf[this.forwardPos++] & 0xFF) << 16 | (this.buf[this.forwardPos++] & 0xFF) << 8 | this.buf[this.forwardPos++] & 0xFF;
    }

    @Override
    public int readIntAt(int pos) {
        return (this.buf[pos++] & 0xFF) << 24 | (this.buf[pos++] & 0xFF) << 16 | (this.buf[pos++] & 0xFF) << 8 | this.buf[pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        long l = this.buf[this.forwardPos++] & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(this.buf[this.forwardPos++] & 0xFF);
        }
        return l;
    }

    @Override
    public long readLongAt(int pos) {
        long l = this.buf[pos++] & 0xFF;
        for (int i = 0; i < 7; ++i) {
            l <<= 8;
            l |= (long)(this.buf[pos++] & 0xFF);
        }
        return l;
    }

    @Override
    public void reverseWrite(byte b) {
        this.buf[this.reversePos--] = b;
    }

    @Override
    public byte reverseRead() {
        return this.buf[this.reversePos--];
    }

    @Override
    public void reverseWriteInt(int i) {
        this.buf[this.reversePos--] = (byte)(i >>> 24);
        this.buf[this.reversePos--] = (byte)(i >>> 16);
        this.buf[this.reversePos--] = (byte)(i >>> 8);
        this.buf[this.reversePos--] = (byte)i;
    }

    @Override
    public void reverseWriteInt0() {
        this.buf[this.reversePos--] = 0;
        this.buf[this.reversePos--] = 0;
        this.buf[this.reversePos--] = 0;
        this.buf[this.reversePos--] = 0;
    }

    @Override
    public int reverseReadInt() {
        return (this.buf[this.reversePos--] & 0xFF) << 24 | (this.buf[this.reversePos--] & 0xFF) << 16 | (this.buf[this.reversePos--] & 0xFF) << 8 | this.buf[this.reversePos--] & 0xFF;
    }

    @Override
    public void skip(int length) {
        this.forwardPos += length;
    }

    @Override
    public void reverseSkip(int length) {
        this.reversePos -= length;
    }

    @Override
    public void reverseSkipInt() {
        this.reversePos -= 4;
    }

    @Override
    public void ensureRemainder(int length) {
        if (this.forwardPos + length - 1 > this.reversePos) {
            int newSize = length > 100 ? this.buf.length + length : this.buf.length + 100;
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.forwardPos);
            int reverseSize = this.buf.length - this.reversePos - 1;
            System.arraycopy(this.buf, this.reversePos + 1, newBuf, newSize - reverseSize, reverseSize);
            this.reversePos = newSize - reverseSize - 1;
            this.buf = newBuf;
        }
    }

    @Override
    public void resize(int oldSize, int newSize) {
        if (oldSize != newSize) {
            byte[] newBuf = new byte[this.buf.length + newSize - oldSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.forwardPos);
            int backPos = this.forwardPos + oldSize;
            System.arraycopy(this.buf, backPos, newBuf, this.forwardPos + newSize, this.buf.length - backPos);
            this.buf = newBuf;
            this.reversePos += newSize - oldSize;
        }
    }

    @Override
    public void setForwardOffset(int pos) {
        this.forwardPos = pos;
    }

    @Override
    public boolean isEnd() {
        return this.reversePos - this.forwardPos + 1 == 0;
    }

    @Override
    public int restReadableSize() {
        return this.buf.length - this.forwardPos - 1;
    }

    @Override
    public int readOffset() {
        return this.forwardPos;
    }

    @Override
    public byte[] getBytes() {
        int emptySize = this.reversePos - this.forwardPos + 1;
        if (emptySize == 0) {
            return this.buf;
        }
        if (emptySize > 0) {
            int finalSize = this.buf.length - emptySize;
            byte[] finalBuf = new byte[finalSize];
            System.arraycopy(this.buf, 0, finalBuf, 0, this.forwardPos);
            System.arraycopy(this.buf, this.reversePos + 1, finalBuf, this.forwardPos, finalSize - this.forwardPos);
            this.buf = finalBuf;
            this.reversePos = this.forwardPos - 1;
            return this.buf;
        }
        if (emptySize < 0) {
            throw new RuntimeException("Wrong Key Buf");
        }
        return null;
    }
}

