/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.index;

import io.dingodb.sdk.common.index.Index;
import io.dingodb.sdk.common.index.IndexParameter;
import io.dingodb.sdk.common.partition.Partition;
import io.dingodb.sdk.common.partition.PartitionRule;

public class IndexDefinition
implements Index {
    private String name;
    private Integer version;
    private PartitionRule partitionRule;
    private Integer replica;
    private IndexParameter parameter;
    private Boolean isAutoIncrement;
    private Long autoIncrement;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public Partition getIndexPartition() {
        return this.partitionRule;
    }

    @Override
    public Integer getReplica() {
        return this.replica;
    }

    @Override
    public IndexParameter getIndexParameter() {
        return this.parameter;
    }

    @Override
    public Boolean getIsAutoIncrement() {
        return this.isAutoIncrement;
    }

    @Override
    public Long getAutoIncrement() {
        return this.autoIncrement;
    }

    public static IndexDefinitionBuilder builder() {
        return new IndexDefinitionBuilder();
    }

    public String toString() {
        return "IndexDefinition(name=" + this.getName() + ", version=" + this.getVersion() + ", partitionRule=" + String.valueOf(this.partitionRule) + ", replica=" + this.getReplica() + ", parameter=" + String.valueOf(this.parameter) + ", isAutoIncrement=" + this.getIsAutoIncrement() + ", autoIncrement=" + this.getAutoIncrement() + ")";
    }

    public IndexDefinition() {
    }

    public IndexDefinition(String name, Integer version, PartitionRule partitionRule, Integer replica, IndexParameter parameter, Boolean isAutoIncrement, Long autoIncrement) {
        this.name = name;
        this.version = version;
        this.partitionRule = partitionRule;
        this.replica = replica;
        this.parameter = parameter;
        this.isAutoIncrement = isAutoIncrement;
        this.autoIncrement = autoIncrement;
    }

    public static class IndexDefinitionBuilder {
        private String name;
        private Integer version;
        private PartitionRule partitionRule;
        private Integer replica;
        private IndexParameter parameter;
        private Boolean isAutoIncrement;
        private Long autoIncrement;

        IndexDefinitionBuilder() {
        }

        public IndexDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public IndexDefinitionBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public IndexDefinitionBuilder partitionRule(PartitionRule partitionRule) {
            this.partitionRule = partitionRule;
            return this;
        }

        public IndexDefinitionBuilder replica(Integer replica) {
            this.replica = replica;
            return this;
        }

        public IndexDefinitionBuilder parameter(IndexParameter parameter) {
            this.parameter = parameter;
            return this;
        }

        public IndexDefinitionBuilder isAutoIncrement(Boolean isAutoIncrement) {
            this.isAutoIncrement = isAutoIncrement;
            return this;
        }

        public IndexDefinitionBuilder autoIncrement(Long autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this;
        }

        public IndexDefinition build() {
            return new IndexDefinition(this.name, this.version, this.partitionRule, this.replica, this.parameter, this.isAutoIncrement, this.autoIncrement);
        }

        public String toString() {
            return "IndexDefinition.IndexDefinitionBuilder(name=" + this.name + ", version=" + this.version + ", partitionRule=" + String.valueOf(this.partitionRule) + ", replica=" + this.replica + ", parameter=" + String.valueOf(this.parameter) + ", isAutoIncrement=" + this.isAutoIncrement + ", autoIncrement=" + this.autoIncrement + ")";
        }
    }
}

