/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common.codec;

import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.codec.CodecUtils;
import io.dingodb.sdk.common.codec.KeyValueCodec;
import io.dingodb.sdk.common.serial.RecordDecoder;
import io.dingodb.sdk.common.serial.RecordEncoder;
import io.dingodb.sdk.common.serial.schema.DingoSchema;
import io.dingodb.sdk.common.table.Column;
import io.dingodb.sdk.common.table.Table;
import io.dingodb.sdk.common.utils.Optional;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DingoKeyValueCodec
implements KeyValueCodec {
    private final long id;
    private final List<DingoSchema> schemas;
    RecordEncoder re;
    RecordDecoder rd;

    public DingoKeyValueCodec(long id, List<DingoSchema> schemas) {
        this(1, id, schemas);
    }

    public DingoKeyValueCodec(int schemaVersion, long id, List<DingoSchema> schemas) {
        this.schemas = schemas;
        this.id = id;
        this.re = new RecordEncoder(schemaVersion, schemas, id);
        this.rd = new RecordDecoder(schemaVersion, schemas, id);
    }

    public DingoKeyValueCodec(int codecVersion, int schemaVersion, long id, List<DingoSchema> schemas) {
        this.schemas = schemas;
        this.id = id;
        this.re = new RecordEncoder(codecVersion, schemaVersion, schemas, id);
        this.rd = new RecordDecoder(schemaVersion, schemas, id);
    }

    public static DingoKeyValueCodec of(Table table2) {
        return DingoKeyValueCodec.of(table2.getCodecVersion(), table2.getVersion(), Optional.mapOrGet(table2.id(), DingoCommonId::entityId, () -> 0L), table2.getColumns());
    }

    public static DingoKeyValueCodec of(long id, Table table2) {
        return DingoKeyValueCodec.of(table2.getVersion(), id, table2);
    }

    public static DingoKeyValueCodec of(int codecVersion, long id, List<Column> columns) {
        return DingoKeyValueCodec.of(codecVersion, 1, id, columns);
    }

    public static DingoKeyValueCodec of(int schemaVersion, long id, Table table2) {
        return DingoKeyValueCodec.of(table2.getCodecVersion(), schemaVersion, id, table2.getColumns());
    }

    public static DingoKeyValueCodec of(int codecVersion, int schemaVersion, long id, List<Column> columns) {
        return new DingoKeyValueCodec(codecVersion, schemaVersion, id, CodecUtils.createSchemaForColumns(columns));
    }

    @Override
    public Object[] decode(KeyValue keyValue) {
        return this.rd.decode(keyValue);
    }

    @Override
    public Object[] decodeKeyPrefix(byte[] keyPrefix) {
        return this.rd.decodeKeyPrefix(keyPrefix);
    }

    @Override
    public KeyValue encode(Object @NonNull [] record) {
        return this.re.encode(record);
    }

    @Override
    public byte[] encodeKey(Object[] record) {
        return this.re.encodeKey(record);
    }

    @Override
    public byte[] encodeKeyPrefix(Object[] record, int columnCount) {
        return this.re.encodeKeyPrefix(record, columnCount);
    }

    @Override
    public byte[] encodeMinKeyPrefix() {
        return this.re.encodeMinKeyPrefix();
    }

    @Override
    public byte[] encodeMaxKeyPrefix() {
        return this.re.encodeMaxKeyPrefix();
    }

    public byte[] resetPrefix(byte[] key) {
        return this.re.resetKeyPrefix(key, this.id);
    }

    @Override
    public byte[] resetPrefix(byte[] key, long prefix) {
        return this.re.resetKeyPrefix(key, prefix);
    }
}

