/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.common;

import io.dingodb.sdk.common.DingoCommonId;
import java.util.function.Function;

public class AutoIncrement {
    public final DingoCommonId tableId;
    public final int increment;
    public final int offset;
    private final Function<DingoCommonId, Increment> fetcher;
    private long limit = 0L;
    private volatile long inc = 0L;

    public AutoIncrement(DingoCommonId tableId, int increment, int offset, Function<DingoCommonId, Increment> fetcher) {
        this.tableId = tableId;
        this.increment = increment;
        this.offset = offset;
        this.fetcher = fetcher;
    }

    public long current() {
        return this.inc;
    }

    public synchronized long inc() {
        long current = this.inc;
        if (current >= this.limit) {
            current = this.fetch();
        }
        this.inc += (long)this.increment;
        return current;
    }

    public synchronized void init() {
        if (this.inc >= this.limit) {
            this.fetch();
        }
    }

    public synchronized void inc(long targetInc) {
        if (targetInc > this.inc) {
            this.inc = targetInc;
        }
    }

    private long fetch() {
        Increment increment = this.fetcher.apply(this.tableId);
        if (increment.inc + (long)this.increment >= increment.limit) {
            throw new RuntimeException("Fetch zero increment, table id: {}" + String.valueOf(this.tableId));
        }
        long incTmp = increment.inc % (long)this.offset != 0L ? increment.inc + (long)this.offset - increment.inc % (long)this.offset : increment.inc;
        if (incTmp > this.inc) {
            this.inc = incTmp;
        }
        this.limit = increment.limit;
        return this.inc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoIncrement)) {
            return false;
        }
        AutoIncrement other = (AutoIncrement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DingoCommonId this$tableId = this.tableId;
        DingoCommonId other$tableId = other.tableId;
        return !(this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoIncrement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DingoCommonId $tableId = this.tableId;
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        return result;
    }

    public long getLimit() {
        return this.limit;
    }

    public static class Increment {
        public final long limit;
        public final long inc;

        public Increment(long limit, long inc) {
            this.limit = limit;
            this.inc = inc;
        }
    }
}

