/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.sdk.service.lock;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.nio.charset.StandardCharsets;

@ToString
@EqualsAndHashCode
@AllArgsConstructor
public class LockInfo {

    public final String key;
    public final String value;
    public final long revision;

    public LockInfo(byte[] key, byte[] value, long revision) {
        this.key = new String(key, StandardCharsets.UTF_8);
        this.value = new String(value, StandardCharsets.UTF_8);
        this.revision = revision;
    }
}
