package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class WatchResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private String cancelReason;

    private boolean canceled;

    private List<Event> events;

    private ResponseHeader header;

    private long watchId;

    private boolean fragment;

    private long compactRevision;

    private boolean created;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, header, out);
        Writer.write(4, watchId, out);
        Writer.write(5, created, out);
        Writer.write(6, canceled, out);
        Writer.write(7, compactRevision, out);
        Writer.write(8, cancelReason, out);
        Writer.write(9, fragment, out);
        Writer.write(11, events, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: header = Reader.readMessage(new ResponseHeader(), input); hasValue = hasValue ? hasValue : header != null; break;
                case 4: watchId = Reader.readLong(input); hasValue = true; break;
                case 5: created = Reader.readBoolean(input); hasValue = true; break;
                case 6: canceled = Reader.readBoolean(input); hasValue = true; break;
                case 7: compactRevision = Reader.readLong(input); hasValue = true; break;
                case 8: cancelReason = Reader.readString(input); hasValue = true; break;
                case 9: fragment = Reader.readBoolean(input); hasValue = true; break;
                case 11: events = Reader.readList(events, input, in -> Reader.readMessage(new Event(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, header);
        size += SizeUtils.sizeOf(4, watchId);
        size += SizeUtils.sizeOf(5, created);
        size += SizeUtils.sizeOf(6, canceled);
        size += SizeUtils.sizeOf(7, compactRevision);
        size += SizeUtils.sizeOf(8, cancelReason);
        size += SizeUtils.sizeOf(9, fragment);
        size += SizeUtils.sizeOf(11, events, SizeUtils::sizeOf);
        return size;
    }
}
