package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class WatchRequest implements Message, Message.Request {
    private RequestInfo requestInfo;

    private RequestUnionNest requestUnion;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(requestUnion, requestUnion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: requestUnion = Reader.readMessage(new RequestUnionNest.CreateRequest(), input); hasValue = hasValue ? hasValue : requestUnion != null; break;
                case 3: requestUnion = Reader.readMessage(new RequestUnionNest.CancelRequest(), input); hasValue = hasValue ? hasValue : requestUnion != null; break;
                case 4: requestUnion = Reader.readMessage(new RequestUnionNest.ProgressRequest(), input); hasValue = hasValue ? hasValue : requestUnion != null; break;
                case 5: requestUnion = Reader.readMessage(new RequestUnionNest.OneTimeRequest(), input); hasValue = hasValue ? hasValue : requestUnion != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(requestUnion, requestUnion);
        return size;
    }

    public interface RequestUnionNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class CreateRequest extends WatchCreateRequest implements RequestUnionNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.CREATE_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class CancelRequest extends WatchCancelRequest implements RequestUnionNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.CANCEL_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class ProgressRequest extends WatchProgressRequest implements RequestUnionNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.PROGRESS_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class OneTimeRequest extends OneTimeWatchRequest implements RequestUnionNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.ONE_TIME_REQUEST;
            }
        }

        enum Nest implements Numeric {
            CREATE_REQUEST(2),

            CANCEL_REQUEST(3),

            PROGRESS_REQUEST(4),

            ONE_TIME_REQUEST(5);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
