package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class WatchCreateRequest implements Message {
    private long startRevision;

    private long watchId;

    private boolean progressNotify;

    private boolean fragment;

    private List<EventFilterType> filters;

    private byte[] key;

    private boolean needPrevKv;

    private byte[] rangeEnd;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, key, out);
        Writer.write(2, rangeEnd, out);
        Writer.write(3, startRevision, out);
        Writer.write(4, progressNotify, out);
        Writer.write(5, filters, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, needPrevKv, out);
        Writer.write(7, watchId, out);
        Writer.write(8, fragment, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: key = Reader.readBytes(input); hasValue = true; break;
                case 2: rangeEnd = Reader.readBytes(input); hasValue = true; break;
                case 3: startRevision = Reader.readLong(input); hasValue = true; break;
                case 4: progressNotify = Reader.readBoolean(input); hasValue = true; break;
                case 5: filters = Reader.readList(filters, input, in -> EventFilterType.forNumber(Reader.readInt(input))); hasValue = true; break;
                case 6: needPrevKv = Reader.readBoolean(input); hasValue = true; break;
                case 7: watchId = Reader.readLong(input); hasValue = true; break;
                case 8: fragment = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, key);
        size += SizeUtils.sizeOf(2, rangeEnd);
        size += SizeUtils.sizeOf(3, startRevision);
        size += SizeUtils.sizeOf(4, progressNotify);
        size += SizeUtils.sizeOf(5, filters, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, needPrevKv);
        size += SizeUtils.sizeOf(7, watchId);
        size += SizeUtils.sizeOf(8, fragment);
        return size;
    }
}
