package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ResponseHeader implements Message {
    private long clusterId;

    private long coordinatorId;

    private long revision;

    private long raftTerm;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, clusterId, out);
        Writer.write(2, coordinatorId, out);
        Writer.write(3, revision, out);
        Writer.write(4, raftTerm, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: clusterId = Reader.readLong(input); hasValue = true; break;
                case 2: coordinatorId = Reader.readLong(input); hasValue = true; break;
                case 3: revision = Reader.readLong(input); hasValue = true; break;
                case 4: raftTerm = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, clusterId);
        size += SizeUtils.sizeOf(2, coordinatorId);
        size += SizeUtils.sizeOf(3, revision);
        size += SizeUtils.sizeOf(4, raftTerm);
        return size;
    }
}
