package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RangeRequest implements Message, Message.Request {
    private boolean countOnly;

    private boolean keysOnly;

    private boolean serializable;

    private long maxModRevision;

    private long minCreateRevision;

    private long limit;

    private long revision;

    private byte[] key;

    private RequestInfo requestInfo;

    private byte[] rangeEnd;

    private long minModRevision;

    private long maxCreateRevision;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, key, out);
        Writer.write(3, rangeEnd, out);
        Writer.write(4, limit, out);
        Writer.write(5, revision, out);
        Writer.write(7, serializable, out);
        Writer.write(8, keysOnly, out);
        Writer.write(9, countOnly, out);
        Writer.write(10, minModRevision, out);
        Writer.write(11, maxModRevision, out);
        Writer.write(12, minCreateRevision, out);
        Writer.write(13, maxCreateRevision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: key = Reader.readBytes(input); hasValue = true; break;
                case 3: rangeEnd = Reader.readBytes(input); hasValue = true; break;
                case 4: limit = Reader.readLong(input); hasValue = true; break;
                case 5: revision = Reader.readLong(input); hasValue = true; break;
                case 7: serializable = Reader.readBoolean(input); hasValue = true; break;
                case 8: keysOnly = Reader.readBoolean(input); hasValue = true; break;
                case 9: countOnly = Reader.readBoolean(input); hasValue = true; break;
                case 10: minModRevision = Reader.readLong(input); hasValue = true; break;
                case 11: maxModRevision = Reader.readLong(input); hasValue = true; break;
                case 12: minCreateRevision = Reader.readLong(input); hasValue = true; break;
                case 13: maxCreateRevision = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, key);
        size += SizeUtils.sizeOf(3, rangeEnd);
        size += SizeUtils.sizeOf(4, limit);
        size += SizeUtils.sizeOf(5, revision);
        size += SizeUtils.sizeOf(7, serializable);
        size += SizeUtils.sizeOf(8, keysOnly);
        size += SizeUtils.sizeOf(9, countOnly);
        size += SizeUtils.sizeOf(10, minModRevision);
        size += SizeUtils.sizeOf(11, maxModRevision);
        size += SizeUtils.sizeOf(12, minCreateRevision);
        size += SizeUtils.sizeOf(13, maxCreateRevision);
        return size;
    }
}
