package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.KeyValue;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class PutRequest implements Message, Message.Request {
    private boolean ignoreValue;

    private boolean ignoreLease;

    private KeyValue keyValue;

    private long lease;

    private RequestInfo requestInfo;

    private boolean needPrevKv;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, keyValue, out);
        Writer.write(3, lease, out);
        Writer.write(4, needPrevKv, out);
        Writer.write(5, ignoreValue, out);
        Writer.write(6, ignoreLease, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: keyValue = Reader.readMessage(new KeyValue(), input); hasValue = hasValue ? hasValue : keyValue != null; break;
                case 3: lease = Reader.readLong(input); hasValue = true; break;
                case 4: needPrevKv = Reader.readBoolean(input); hasValue = true; break;
                case 5: ignoreValue = Reader.readBoolean(input); hasValue = true; break;
                case 6: ignoreLease = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, keyValue);
        size += SizeUtils.sizeOf(3, lease);
        size += SizeUtils.sizeOf(4, needPrevKv);
        size += SizeUtils.sizeOf(5, ignoreValue);
        size += SizeUtils.sizeOf(6, ignoreLease);
        return size;
    }
}
