package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class KvInternal implements Message {
    private RevisionInternal createRevision;

    private RevisionInternal modRevision;

    private boolean isDeleted;

    private byte[] id;

    private long version;

    private long lease;

    private byte[] value;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, value, out);
        Writer.write(3, createRevision, out);
        Writer.write(4, modRevision, out);
        Writer.write(5, version, out);
        Writer.write(6, lease, out);
        Writer.write(7, isDeleted, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readBytes(input); hasValue = true; break;
                case 2: value = Reader.readBytes(input); hasValue = true; break;
                case 3: createRevision = Reader.readMessage(new RevisionInternal(), input); hasValue = hasValue ? hasValue : createRevision != null; break;
                case 4: modRevision = Reader.readMessage(new RevisionInternal(), input); hasValue = hasValue ? hasValue : modRevision != null; break;
                case 5: version = Reader.readLong(input); hasValue = true; break;
                case 6: lease = Reader.readLong(input); hasValue = true; break;
                case 7: isDeleted = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, value);
        size += SizeUtils.sizeOf(3, createRevision);
        size += SizeUtils.sizeOf(4, modRevision);
        size += SizeUtils.sizeOf(5, version);
        size += SizeUtils.sizeOf(6, lease);
        size += SizeUtils.sizeOf(7, isDeleted);
        return size;
    }
}
