package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.KeyValue;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Kv implements Message {
    private long createRevision;

    private long modRevision;

    private long version;

    private long lease;

    private KeyValue kv;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, kv, out);
        Writer.write(2, createRevision, out);
        Writer.write(3, modRevision, out);
        Writer.write(4, version, out);
        Writer.write(6, lease, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: kv = Reader.readMessage(new KeyValue(), input); hasValue = hasValue ? hasValue : kv != null; break;
                case 2: createRevision = Reader.readLong(input); hasValue = true; break;
                case 3: modRevision = Reader.readLong(input); hasValue = true; break;
                case 4: version = Reader.readLong(input); hasValue = true; break;
                case 6: lease = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, kv);
        size += SizeUtils.sizeOf(2, createRevision);
        size += SizeUtils.sizeOf(3, modRevision);
        size += SizeUtils.sizeOf(4, version);
        size += SizeUtils.sizeOf(6, lease);
        return size;
    }
}
