package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Generation implements Message {
    private RevisionInternal createRevision;

    private long verison;

    private List<RevisionInternal> revisions;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, verison, out);
        Writer.write(2, createRevision, out);
        Writer.write(3, revisions, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: verison = Reader.readLong(input); hasValue = true; break;
                case 2: createRevision = Reader.readMessage(new RevisionInternal(), input); hasValue = hasValue ? hasValue : createRevision != null; break;
                case 3: revisions = Reader.readList(revisions, input, in -> Reader.readMessage(new RevisionInternal(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, verison);
        size += SizeUtils.sizeOf(2, createRevision);
        size += SizeUtils.sizeOf(3, revisions, SizeUtils::sizeOf);
        return size;
    }
}
