package io.dingodb.sdk.service.entity.version;

import io.dingodb.sdk.service.entity.Numeric;

public enum EventType implements Numeric {
    UNRECOGNIZED(-1),

    NONE(0),

    PUT(1),

    DELETE(2),

    NOT_EXISTS(3);

    public final Integer number;

    private Object ext$;

    private EventType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static EventType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return NONE;
            case 1: return PUT;
            case 2: return DELETE;
            case 3: return NOT_EXISTS;
            default: return null;
        }
    }
}
