package io.dingodb.sdk.service.entity.version;

import io.dingodb.sdk.service.entity.Numeric;

public enum EventFilterType implements Numeric {
    UNRECOGNIZED(-1),

    NOPUT(0),

    NODELETE(1);

    public final Integer number;

    private Object ext$;

    private EventFilterType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static EventFilterType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return NOPUT;
            case 1: return NODELETE;
            default: return null;
        }
    }
}
