package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Event implements Message {
    private Kv prevKv;

    private Kv kv;

    private EventType type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, type, out);
        Writer.write(2, kv, out);
        Writer.write(3, prevKv, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: type = EventType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: kv = Reader.readMessage(new Kv(), input); hasValue = hasValue ? hasValue : kv != null; break;
                case 3: prevKv = Reader.readMessage(new Kv(), input); hasValue = hasValue ? hasValue : prevKv != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, type);
        size += SizeUtils.sizeOf(2, kv);
        size += SizeUtils.sizeOf(3, prevKv);
        return size;
    }
}
