package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DeleteRangeResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private ResponseHeader header;

    private long deleted;

    private List<Kv> prevKvs;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, header, out);
        Writer.write(4, deleted, out);
        Writer.write(5, prevKvs, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: header = Reader.readMessage(new ResponseHeader(), input); hasValue = hasValue ? hasValue : header != null; break;
                case 4: deleted = Reader.readLong(input); hasValue = true; break;
                case 5: prevKvs = Reader.readList(prevKvs, input, in -> Reader.readMessage(new Kv(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, header);
        size += SizeUtils.sizeOf(4, deleted);
        size += SizeUtils.sizeOf(5, prevKvs, SizeUtils::sizeOf);
        return size;
    }
}
