package io.dingodb.sdk.service.entity.store_internal;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.coordinator.RegionCmdType;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionChangeRecord implements Message {
    private RegionCmdType jobType;

    private long jobId;

    private String beginTime;

    private String jobContent;

    private List<TimePoint> timeline;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, regionId, out);
        Writer.write(2, jobType, out);
        Writer.write(3, jobId, out);
        Writer.write(4, jobContent, out);
        Writer.write(5, beginTime, out);
        Writer.write(6, timeline, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: regionId = Reader.readLong(input); hasValue = true; break;
                case 2: jobType = RegionCmdType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: jobId = Reader.readLong(input); hasValue = true; break;
                case 4: jobContent = Reader.readString(input); hasValue = true; break;
                case 5: beginTime = Reader.readString(input); hasValue = true; break;
                case 6: timeline = Reader.readList(timeline, input, in -> Reader.readMessage(new TimePoint(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, regionId);
        size += SizeUtils.sizeOf(2, jobType);
        size += SizeUtils.sizeOf(3, jobId);
        size += SizeUtils.sizeOf(4, jobContent);
        size += SizeUtils.sizeOf(5, beginTime);
        size += SizeUtils.sizeOf(6, timeline, SizeUtils::sizeOf);
        return size;
    }
}
