package io.dingodb.sdk.service.entity.store_internal;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionDefinition;
import io.dingodb.sdk.service.entity.common.RegionType;
import io.dingodb.sdk.service.entity.common.StoreRegionState;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Region implements Message {
    private long snapshotEpochVersion;

    private StoreRegionState state;

    private boolean needBootstrapDoSnapshot;

    private List<StoreRegionState> historyStates;

    private boolean disableChange;

    private long lastSplitTimestamp;

    private boolean temporaryDisableChange;

    private long lastChangeJobId;

    private long leaderId;

    private long id;

    private RegionType regionType;

    private Range encodeRange;

    private RegionDefinition definition;

    private long parentId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(10, regionType, out);
        Writer.write(20, definition, out);
        Writer.write(21, encodeRange, out);
        Writer.write(30, leaderId, out);
        Writer.write(40, state, out);
        Writer.write(50, historyStates, (n, v) -> Writer.write(n, v, out));
        Writer.write(51, needBootstrapDoSnapshot, out);
        Writer.write(69, temporaryDisableChange, out);
        Writer.write(70, disableChange, out);
        Writer.write(71, lastSplitTimestamp, out);
        Writer.write(72, parentId, out);
        Writer.write(74, snapshotEpochVersion, out);
        Writer.write(76, lastChangeJobId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 10: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 20: definition = Reader.readMessage(new RegionDefinition(), input); hasValue = hasValue ? hasValue : definition != null; break;
                case 21: encodeRange = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : encodeRange != null; break;
                case 30: leaderId = Reader.readLong(input); hasValue = true; break;
                case 40: state = StoreRegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 50: historyStates = Reader.readList(historyStates, input, in -> StoreRegionState.forNumber(Reader.readInt(input))); hasValue = true; break;
                case 51: needBootstrapDoSnapshot = Reader.readBoolean(input); hasValue = true; break;
                case 69: temporaryDisableChange = Reader.readBoolean(input); hasValue = true; break;
                case 70: disableChange = Reader.readBoolean(input); hasValue = true; break;
                case 71: lastSplitTimestamp = Reader.readLong(input); hasValue = true; break;
                case 72: parentId = Reader.readLong(input); hasValue = true; break;
                case 74: snapshotEpochVersion = Reader.readLong(input); hasValue = true; break;
                case 76: lastChangeJobId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(10, regionType);
        size += SizeUtils.sizeOf(20, definition);
        size += SizeUtils.sizeOf(21, encodeRange);
        size += SizeUtils.sizeOf(30, leaderId);
        size += SizeUtils.sizeOf(40, state);
        size += SizeUtils.sizeOf(50, historyStates, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(51, needBootstrapDoSnapshot);
        size += SizeUtils.sizeOf(69, temporaryDisableChange);
        size += SizeUtils.sizeOf(70, disableChange);
        size += SizeUtils.sizeOf(71, lastSplitTimestamp);
        size += SizeUtils.sizeOf(72, parentId);
        size += SizeUtils.sizeOf(74, snapshotEpochVersion);
        size += SizeUtils.sizeOf(76, lastChangeJobId);
        return size;
    }
}
