package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class WriteConflict implements Message {
    private long startTs;

    private byte[] primaryKey;

    private long conflictTs;

    private byte[] key;

    private long conflictCommitTs;

    private Reason reason;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, reason, out);
        Writer.write(2, startTs, out);
        Writer.write(3, conflictTs, out);
        Writer.write(4, conflictCommitTs, out);
        Writer.write(5, key, out);
        Writer.write(6, primaryKey, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: reason = Reason.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: startTs = Reader.readLong(input); hasValue = true; break;
                case 3: conflictTs = Reader.readLong(input); hasValue = true; break;
                case 4: conflictCommitTs = Reader.readLong(input); hasValue = true; break;
                case 5: key = Reader.readBytes(input); hasValue = true; break;
                case 6: primaryKey = Reader.readBytes(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, reason);
        size += SizeUtils.sizeOf(2, startTs);
        size += SizeUtils.sizeOf(3, conflictTs);
        size += SizeUtils.sizeOf(4, conflictCommitTs);
        size += SizeUtils.sizeOf(5, key);
        size += SizeUtils.sizeOf(6, primaryKey);
        return size;
    }
}
