package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DocumentWithId;
import io.dingodb.sdk.service.entity.common.KeyValue;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.common.VectorWithId;
import io.dingodb.sdk.service.entity.error.Error;
import io.dingodb.sdk.service.entity.stream.StreamResponseMeta;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnScanResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private StreamResponseMeta streamMeta;

    private List<KeyValue> kvs;

    private List<DocumentWithId> documents;

    private boolean hasMore;

    private TxnResultInfo txnResult;

    private List<VectorWithId> vectors;

    private byte[] endKey;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, txnResult, out);
        Writer.write(4, kvs, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, vectors, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, hasMore, out);
        Writer.write(7, endKey, out);
        Writer.write(8, documents, (n, v) -> Writer.write(n, v, out));
        Writer.write(30, streamMeta, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: txnResult = Reader.readMessage(new TxnResultInfo(), input); hasValue = hasValue ? hasValue : txnResult != null; break;
                case 4: kvs = Reader.readList(kvs, input, in -> Reader.readMessage(new KeyValue(), in)); hasValue = true; break;
                case 5: vectors = Reader.readList(vectors, input, in -> Reader.readMessage(new VectorWithId(), in)); hasValue = true; break;
                case 6: hasMore = Reader.readBoolean(input); hasValue = true; break;
                case 7: endKey = Reader.readBytes(input); hasValue = true; break;
                case 8: documents = Reader.readList(documents, input, in -> Reader.readMessage(new DocumentWithId(), in)); hasValue = true; break;
                case 30: streamMeta = Reader.readMessage(new StreamResponseMeta(), input); hasValue = hasValue ? hasValue : streamMeta != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, txnResult);
        size += SizeUtils.sizeOf(4, kvs, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, hasMore);
        size += SizeUtils.sizeOf(7, endKey);
        size += SizeUtils.sizeOf(8, documents, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(30, streamMeta);
        return size;
    }
}
