package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.CoprocessorV2;
import io.dingodb.sdk.service.entity.common.RangeWithOptions;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.stream.StreamRequestMeta;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnScanRequest implements Message, Message.Request, Message.StoreRequest {
    private long startTs;

    private StreamRequestMeta streamMeta;

    private Context context;

    private int limit;

    private RangeWithOptions range;

    private RequestInfo requestInfo;

    private boolean keyOnly;

    private boolean isReverse;

    private CoprocessorV2 coprocessor;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, range, out);
        Writer.write(4, limit, out);
        Writer.write(5, startTs, out);
        Writer.write(6, keyOnly, out);
        Writer.write(7, isReverse, out);
        Writer.write(20, coprocessor, out);
        Writer.write(30, streamMeta, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: range = Reader.readMessage(new RangeWithOptions(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 4: limit = Reader.readInt(input); hasValue = true; break;
                case 5: startTs = Reader.readLong(input); hasValue = true; break;
                case 6: keyOnly = Reader.readBoolean(input); hasValue = true; break;
                case 7: isReverse = Reader.readBoolean(input); hasValue = true; break;
                case 20: coprocessor = Reader.readMessage(new CoprocessorV2(), input); hasValue = hasValue ? hasValue : coprocessor != null; break;
                case 30: streamMeta = Reader.readMessage(new StreamRequestMeta(), input); hasValue = hasValue ? hasValue : streamMeta != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, range);
        size += SizeUtils.sizeOf(4, limit);
        size += SizeUtils.sizeOf(5, startTs);
        size += SizeUtils.sizeOf(6, keyOnly);
        size += SizeUtils.sizeOf(7, isReverse);
        size += SizeUtils.sizeOf(20, coprocessor);
        size += SizeUtils.sizeOf(30, streamMeta);
        return size;
    }
}
