package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.stream.StreamRequestMeta;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnScanLockRequest implements Message, Message.Request, Message.StoreRequest {
    private StreamRequestMeta streamMeta;

    private long maxTs;

    private Context context;

    private int limit;

    private RequestInfo requestInfo;

    private byte[] startKey;

    private byte[] endKey;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, maxTs, out);
        Writer.write(4, startKey, out);
        Writer.write(5, endKey, out);
        Writer.write(6, limit, out);
        Writer.write(30, streamMeta, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: maxTs = Reader.readLong(input); hasValue = true; break;
                case 4: startKey = Reader.readBytes(input); hasValue = true; break;
                case 5: endKey = Reader.readBytes(input); hasValue = true; break;
                case 6: limit = Reader.readInt(input); hasValue = true; break;
                case 30: streamMeta = Reader.readMessage(new StreamRequestMeta(), input); hasValue = hasValue ? hasValue : streamMeta != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, maxTs);
        size += SizeUtils.sizeOf(4, startKey);
        size += SizeUtils.sizeOf(5, endKey);
        size += SizeUtils.sizeOf(6, limit);
        size += SizeUtils.sizeOf(30, streamMeta);
        return size;
    }
}
