package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnResultInfo implements Message {
    private LockInfo locked;

    private WriteConflict writeConflict;

    private CommitTsExpired commitTsExpired;

    private TxnNotFound txnNotFound;

    private PrimaryMismatch primaryMismatch;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, locked, out);
        Writer.write(2, writeConflict, out);
        Writer.write(3, txnNotFound, out);
        Writer.write(4, primaryMismatch, out);
        Writer.write(5, commitTsExpired, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: locked = Reader.readMessage(new LockInfo(), input); hasValue = hasValue ? hasValue : locked != null; break;
                case 2: writeConflict = Reader.readMessage(new WriteConflict(), input); hasValue = hasValue ? hasValue : writeConflict != null; break;
                case 3: txnNotFound = Reader.readMessage(new TxnNotFound(), input); hasValue = hasValue ? hasValue : txnNotFound != null; break;
                case 4: primaryMismatch = Reader.readMessage(new PrimaryMismatch(), input); hasValue = hasValue ? hasValue : primaryMismatch != null; break;
                case 5: commitTsExpired = Reader.readMessage(new CommitTsExpired(), input); hasValue = hasValue ? hasValue : commitTsExpired != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, locked);
        size += SizeUtils.sizeOf(2, writeConflict);
        size += SizeUtils.sizeOf(3, txnNotFound);
        size += SizeUtils.sizeOf(4, primaryMismatch);
        size += SizeUtils.sizeOf(5, commitTsExpired);
        return size;
    }
}
