package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnPrewriteResponse implements Message, Message.Response {
    private Error error;

    private List<AlreadyExist> keysAlreadyExist;

    private ResponseInfo responseInfo;

    private List<TxnResultInfo> txnResult;

    private long minCommitTs;

    private long onePcCommitTs;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, txnResult, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, keysAlreadyExist, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, onePcCommitTs, out);
        Writer.write(6, minCommitTs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: txnResult = Reader.readList(txnResult, input, in -> Reader.readMessage(new TxnResultInfo(), in)); hasValue = true; break;
                case 4: keysAlreadyExist = Reader.readList(keysAlreadyExist, input, in -> Reader.readMessage(new AlreadyExist(), in)); hasValue = true; break;
                case 5: onePcCommitTs = Reader.readLong(input); hasValue = true; break;
                case 6: minCommitTs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, txnResult, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, keysAlreadyExist, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, onePcCommitTs);
        size += SizeUtils.sizeOf(6, minCommitTs);
        return size;
    }
}
