package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnPrewriteRequest implements Message, Message.Request, Message.StoreRequest {
    private boolean tryOnePc;

    private List<Mutation> mutations;

    private List<PessimisticCheck> pessimisticChecks;

    private byte[] primaryLock;

    private List<byte[]> secondaries;

    private long maxCommitTs;

    private RequestInfo requestInfo;

    private long txnSize;

    private long minCommitTs;

    private long lockTtl;

    private long startTs;

    private boolean useAsyncCommit;

    private List<LockExtraData> lockExtraDatas;

    private Context context;

    private List<ForUpdateTsCheck> forUpdateTsChecks;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, mutations, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, primaryLock, out);
        Writer.write(5, startTs, out);
        Writer.write(6, lockTtl, out);
        Writer.write(7, txnSize, out);
        Writer.write(8, tryOnePc, out);
        Writer.write(9, maxCommitTs, out);
        Writer.write(10, pessimisticChecks, (n, v) -> Writer.write(n, v, out));
        Writer.write(11, forUpdateTsChecks, (n, v) -> Writer.write(n, v, out));
        Writer.write(12, lockExtraDatas, (n, v) -> Writer.write(n, v, out));
        Writer.write(13, minCommitTs, out);
        Writer.write(14, useAsyncCommit, out);
        Writer.write(15, secondaries, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: mutations = Reader.readList(mutations, input, in -> Reader.readMessage(new Mutation(), in)); hasValue = true; break;
                case 4: primaryLock = Reader.readBytes(input); hasValue = true; break;
                case 5: startTs = Reader.readLong(input); hasValue = true; break;
                case 6: lockTtl = Reader.readLong(input); hasValue = true; break;
                case 7: txnSize = Reader.readLong(input); hasValue = true; break;
                case 8: tryOnePc = Reader.readBoolean(input); hasValue = true; break;
                case 9: maxCommitTs = Reader.readLong(input); hasValue = true; break;
                case 10: pessimisticChecks = Reader.readList(pessimisticChecks, input, in -> PessimisticCheck.forNumber(Reader.readInt(input))); hasValue = true; break;
                case 11: forUpdateTsChecks = Reader.readList(forUpdateTsChecks, input, in -> Reader.readMessage(new ForUpdateTsCheck(), in)); hasValue = true; break;
                case 12: lockExtraDatas = Reader.readList(lockExtraDatas, input, in -> Reader.readMessage(new LockExtraData(), in)); hasValue = true; break;
                case 13: minCommitTs = Reader.readLong(input); hasValue = true; break;
                case 14: useAsyncCommit = Reader.readBoolean(input); hasValue = true; break;
                case 15: secondaries = Reader.readList(secondaries, input, Reader::readBytes); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, mutations, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, primaryLock);
        size += SizeUtils.sizeOf(5, startTs);
        size += SizeUtils.sizeOf(6, lockTtl);
        size += SizeUtils.sizeOf(7, txnSize);
        size += SizeUtils.sizeOf(8, tryOnePc);
        size += SizeUtils.sizeOf(9, maxCommitTs);
        size += SizeUtils.sizeOf(10, pessimisticChecks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(11, forUpdateTsChecks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(12, lockExtraDatas, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(13, minCommitTs);
        size += SizeUtils.sizeOf(14, useAsyncCommit);
        size += SizeUtils.sizeOf(15, secondaries, SizeUtils::sizeOf);
        return size;
    }
}
