package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnPessimisticLockRequest implements Message, Message.Request, Message.StoreRequest {
    private long startTs;

    private long forUpdateTs;

    private List<Mutation> mutations;

    private byte[] primaryLock;

    private Context context;

    private boolean returnValues;

    private RequestInfo requestInfo;

    private long lockTtl;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, mutations, (n, v) -> Writer.write(n, v, out));
        Writer.write(4, primaryLock, out);
        Writer.write(5, startTs, out);
        Writer.write(6, lockTtl, out);
        Writer.write(7, forUpdateTs, out);
        Writer.write(8, returnValues, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: mutations = Reader.readList(mutations, input, in -> Reader.readMessage(new Mutation(), in)); hasValue = true; break;
                case 4: primaryLock = Reader.readBytes(input); hasValue = true; break;
                case 5: startTs = Reader.readLong(input); hasValue = true; break;
                case 6: lockTtl = Reader.readLong(input); hasValue = true; break;
                case 7: forUpdateTs = Reader.readLong(input); hasValue = true; break;
                case 8: returnValues = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, mutations, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, primaryLock);
        size += SizeUtils.sizeOf(5, startTs);
        size += SizeUtils.sizeOf(6, lockTtl);
        size += SizeUtils.sizeOf(7, forUpdateTs);
        size += SizeUtils.sizeOf(8, returnValues);
        return size;
    }
}
