package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnDumpResponse implements Message, Message.Response {
    private ResponseInfo responseInfo;

    private List<TxnLockValue> lockValues;

    private List<TxnDataKey> dataKeys;

    private Error error;

    private List<TxnWriteKey> writeKeys;

    private TxnResultInfo txnResult;

    private List<TxnLockKey> lockKeys;

    private List<TxnWriteValue> writeValues;

    private List<TxnDataValue> dataValues;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, txnResult, out);
        Writer.write(4, dataKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(5, dataValues, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, lockKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(7, lockValues, (n, v) -> Writer.write(n, v, out));
        Writer.write(8, writeKeys, (n, v) -> Writer.write(n, v, out));
        Writer.write(9, writeValues, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: txnResult = Reader.readMessage(new TxnResultInfo(), input); hasValue = hasValue ? hasValue : txnResult != null; break;
                case 4: dataKeys = Reader.readList(dataKeys, input, in -> Reader.readMessage(new TxnDataKey(), in)); hasValue = true; break;
                case 5: dataValues = Reader.readList(dataValues, input, in -> Reader.readMessage(new TxnDataValue(), in)); hasValue = true; break;
                case 6: lockKeys = Reader.readList(lockKeys, input, in -> Reader.readMessage(new TxnLockKey(), in)); hasValue = true; break;
                case 7: lockValues = Reader.readList(lockValues, input, in -> Reader.readMessage(new TxnLockValue(), in)); hasValue = true; break;
                case 8: writeKeys = Reader.readList(writeKeys, input, in -> Reader.readMessage(new TxnWriteKey(), in)); hasValue = true; break;
                case 9: writeValues = Reader.readList(writeValues, input, in -> Reader.readMessage(new TxnWriteValue(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, txnResult);
        size += SizeUtils.sizeOf(4, dataKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, dataValues, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, lockKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(7, lockValues, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(8, writeKeys, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(9, writeValues, SizeUtils::sizeOf);
        return size;
    }
}
