package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnCheckTxnStatusResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private long commitTs;

    private Action action;

    private TxnResultInfo txnResult;

    private LockInfo lockInfo;

    private long lockTtl;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, txnResult, out);
        Writer.write(4, lockTtl, out);
        Writer.write(5, commitTs, out);
        Writer.write(6, action, out);
        Writer.write(7, lockInfo, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: txnResult = Reader.readMessage(new TxnResultInfo(), input); hasValue = hasValue ? hasValue : txnResult != null; break;
                case 4: lockTtl = Reader.readLong(input); hasValue = true; break;
                case 5: commitTs = Reader.readLong(input); hasValue = true; break;
                case 6: action = Action.forNumber(Reader.readInt(input));hasValue = true; break;
                case 7: lockInfo = Reader.readMessage(new LockInfo(), input); hasValue = hasValue ? hasValue : lockInfo != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, txnResult);
        size += SizeUtils.sizeOf(4, lockTtl);
        size += SizeUtils.sizeOf(5, commitTs);
        size += SizeUtils.sizeOf(6, action);
        size += SizeUtils.sizeOf(7, lockInfo);
        return size;
    }
}
