package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TxnCheckTxnStatusRequest implements Message, Message.Request, Message.StoreRequest {
    private long callerStartTs;

    private long currentTs;

    private long lockTs;

    private Context context;

    private byte[] primaryKey;

    private RequestInfo requestInfo;

    private boolean forceSyncCommit;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, primaryKey, out);
        Writer.write(4, lockTs, out);
        Writer.write(5, callerStartTs, out);
        Writer.write(6, currentTs, out);
        Writer.write(7, forceSyncCommit, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: primaryKey = Reader.readBytes(input); hasValue = true; break;
                case 4: lockTs = Reader.readLong(input); hasValue = true; break;
                case 5: callerStartTs = Reader.readLong(input); hasValue = true; break;
                case 6: currentTs = Reader.readLong(input); hasValue = true; break;
                case 7: forceSyncCommit = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, primaryKey);
        size += SizeUtils.sizeOf(4, lockTs);
        size += SizeUtils.sizeOf(5, callerStartTs);
        size += SizeUtils.sizeOf(6, currentTs);
        size += SizeUtils.sizeOf(7, forceSyncCommit);
        return size;
    }
}
