package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Schema;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class SchemaWrapper implements Message {
    private long commonId;

    private List<Schema> schema;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, schema, (n, v) -> Writer.write(n, v, out));
        Writer.write(2, commonId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: schema = Reader.readList(schema, input, in -> Reader.readMessage(new Schema(), in)); hasValue = true; break;
                case 2: commonId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, schema, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, commonId);
        return size;
    }
}
