package io.dingodb.sdk.service.entity.store;

import io.dingodb.sdk.service.entity.Numeric;

public enum Reason implements Numeric {
    UNRECOGNIZED(-1),

    Unknown(0),

    Optimistic(1),

    PessimisticRetry(2),

    SelfRolledBack(3),

    RcCheckTs(4);

    public final Integer number;

    private Object ext$;

    private Reason(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static Reason forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return Unknown;
            case 1: return Optimistic;
            case 2: return PessimisticRetry;
            case 3: return SelfRolledBack;
            case 4: return RcCheckTs;
            default: return null;
        }
    }
}
