package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.DocumentWithId;
import io.dingodb.sdk.service.entity.common.VectorWithId;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Mutation implements Message {
    private DocumentWithId document;

    private Op op;

    private byte[] key;

    private VectorWithId vector;

    private byte[] value;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, op, out);
        Writer.write(2, key, out);
        Writer.write(3, value, out);
        Writer.write(4, vector, out);
        Writer.write(5, document, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: op = Op.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: key = Reader.readBytes(input); hasValue = true; break;
                case 3: value = Reader.readBytes(input); hasValue = true; break;
                case 4: vector = Reader.readMessage(new VectorWithId(), input); hasValue = hasValue ? hasValue : vector != null; break;
                case 5: document = Reader.readMessage(new DocumentWithId(), input); hasValue = hasValue ? hasValue : document != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, op);
        size += SizeUtils.sizeOf(2, key);
        size += SizeUtils.sizeOf(3, value);
        size += SizeUtils.sizeOf(4, vector);
        size += SizeUtils.sizeOf(5, document);
        return size;
    }
}
