package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class LockInfo implements Message {
    private Op lockType;

    private long forUpdateTs;

    private byte[] shortValue;

    private boolean useAsyncCommit;

    private byte[] primaryLock;

    private long lockTs;

    private List<byte[]> secondaries;

    private byte[] extraData;

    private byte[] key;

    private long txnSize;

    private long minCommitTs;

    private long lockTtl;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, primaryLock, out);
        Writer.write(2, key, out);
        Writer.write(3, lockTs, out);
        Writer.write(4, forUpdateTs, out);
        Writer.write(5, lockTtl, out);
        Writer.write(6, txnSize, out);
        Writer.write(7, lockType, out);
        Writer.write(8, shortValue, out);
        Writer.write(9, extraData, out);
        Writer.write(10, minCommitTs, out);
        Writer.write(11, useAsyncCommit, out);
        Writer.write(12, secondaries, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: primaryLock = Reader.readBytes(input); hasValue = true; break;
                case 2: key = Reader.readBytes(input); hasValue = true; break;
                case 3: lockTs = Reader.readLong(input); hasValue = true; break;
                case 4: forUpdateTs = Reader.readLong(input); hasValue = true; break;
                case 5: lockTtl = Reader.readLong(input); hasValue = true; break;
                case 6: txnSize = Reader.readLong(input); hasValue = true; break;
                case 7: lockType = Op.forNumber(Reader.readInt(input));hasValue = true; break;
                case 8: shortValue = Reader.readBytes(input); hasValue = true; break;
                case 9: extraData = Reader.readBytes(input); hasValue = true; break;
                case 10: minCommitTs = Reader.readLong(input); hasValue = true; break;
                case 11: useAsyncCommit = Reader.readBoolean(input); hasValue = true; break;
                case 12: secondaries = Reader.readList(secondaries, input, Reader::readBytes); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, primaryLock);
        size += SizeUtils.sizeOf(2, key);
        size += SizeUtils.sizeOf(3, lockTs);
        size += SizeUtils.sizeOf(4, forUpdateTs);
        size += SizeUtils.sizeOf(5, lockTtl);
        size += SizeUtils.sizeOf(6, txnSize);
        size += SizeUtils.sizeOf(7, lockType);
        size += SizeUtils.sizeOf(8, shortValue);
        size += SizeUtils.sizeOf(9, extraData);
        size += SizeUtils.sizeOf(10, minCommitTs);
        size += SizeUtils.sizeOf(11, useAsyncCommit);
        size += SizeUtils.sizeOf(12, secondaries, SizeUtils::sizeOf);
        return size;
    }
}
