package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.CoprocessorV2;
import io.dingodb.sdk.service.entity.common.RangeWithOptions;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class KvScanBeginRequestV2 implements Message, Message.Request, Message.StoreRequest {
    private long scanId;

    private long maxFetchCnt;

    private Context context;

    private long ts;

    private boolean disableAutoRelease;

    private RangeWithOptions range;

    private RequestInfo requestInfo;

    private boolean keyOnly;

    private CoprocessorV2 coprocessor;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, scanId, out);
        Writer.write(3, context, out);
        Writer.write(4, range, out);
        Writer.write(5, maxFetchCnt, out);
        Writer.write(6, keyOnly, out);
        Writer.write(7, disableAutoRelease, out);
        Writer.write(20, coprocessor, out);
        Writer.write(21, ts, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: scanId = Reader.readLong(input); hasValue = true; break;
                case 3: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 4: range = Reader.readMessage(new RangeWithOptions(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 5: maxFetchCnt = Reader.readLong(input); hasValue = true; break;
                case 6: keyOnly = Reader.readBoolean(input); hasValue = true; break;
                case 7: disableAutoRelease = Reader.readBoolean(input); hasValue = true; break;
                case 20: coprocessor = Reader.readMessage(new CoprocessorV2(), input); hasValue = hasValue ? hasValue : coprocessor != null; break;
                case 21: ts = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, scanId);
        size += SizeUtils.sizeOf(3, context);
        size += SizeUtils.sizeOf(4, range);
        size += SizeUtils.sizeOf(5, maxFetchCnt);
        size += SizeUtils.sizeOf(6, keyOnly);
        size += SizeUtils.sizeOf(7, disableAutoRelease);
        size += SizeUtils.sizeOf(20, coprocessor);
        size += SizeUtils.sizeOf(21, ts);
        return size;
    }
}
