package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RangeWithOptions;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class KvScanBeginRequest implements Message, Message.Request, Message.StoreRequest {
    private boolean disableCoprocessor;

    private long maxFetchCnt;

    private Context context;

    private long ts;

    private boolean disableAutoRelease;

    private RangeWithOptions range;

    private RequestInfo requestInfo;

    private boolean keyOnly;

    private Coprocessor coprocessor;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, range, out);
        Writer.write(4, maxFetchCnt, out);
        Writer.write(5, keyOnly, out);
        Writer.write(6, disableAutoRelease, out);
        Writer.write(7, disableCoprocessor, out);
        Writer.write(8, coprocessor, out);
        Writer.write(9, ts, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: range = Reader.readMessage(new RangeWithOptions(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 4: maxFetchCnt = Reader.readLong(input); hasValue = true; break;
                case 5: keyOnly = Reader.readBoolean(input); hasValue = true; break;
                case 6: disableAutoRelease = Reader.readBoolean(input); hasValue = true; break;
                case 7: disableCoprocessor = Reader.readBoolean(input); hasValue = true; break;
                case 8: coprocessor = Reader.readMessage(new Coprocessor(), input); hasValue = hasValue ? hasValue : coprocessor != null; break;
                case 9: ts = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, range);
        size += SizeUtils.sizeOf(4, maxFetchCnt);
        size += SizeUtils.sizeOf(5, keyOnly);
        size += SizeUtils.sizeOf(6, disableAutoRelease);
        size += SizeUtils.sizeOf(7, disableCoprocessor);
        size += SizeUtils.sizeOf(8, coprocessor);
        size += SizeUtils.sizeOf(9, ts);
        return size;
    }
}
