package io.dingodb.sdk.service.entity.store;

import io.dingodb.sdk.service.entity.Numeric;

public enum IsolationLevel implements Numeric {
    UNRECOGNIZED(-1),

    InvalidIsolationLevel(0),

    SnapshotIsolation(1),

    ReadCommitted(2);

    public final Integer number;

    private Object ext$;

    private IsolationLevel(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static IsolationLevel forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return InvalidIsolationLevel;
            case 1: return SnapshotIsolation;
            case 2: return ReadCommitted;
            default: return null;
        }
    }
}
