package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionMetrics;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.common.StoreOwnMetrics;
import io.dingodb.sdk.service.entity.common.VersionInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class HelloResponse implements Message, Message.Response {
    private long regionLeaderCount;

    private Error error;

    private ResponseInfo responseInfo;

    private StoreOwnMetrics storeOwnMetrics;

    private VersionInfo versionInfo;

    private List<RegionMetrics> regionMetrics;

    private long regionCount;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, regionCount, out);
        Writer.write(4, regionLeaderCount, out);
        Writer.write(5, regionMetrics, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, versionInfo, out);
        Writer.write(7, storeOwnMetrics, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: regionCount = Reader.readLong(input); hasValue = true; break;
                case 4: regionLeaderCount = Reader.readLong(input); hasValue = true; break;
                case 5: regionMetrics = Reader.readList(regionMetrics, input, in -> Reader.readMessage(new RegionMetrics(), in)); hasValue = true; break;
                case 6: versionInfo = Reader.readMessage(new VersionInfo(), input); hasValue = hasValue ? hasValue : versionInfo != null; break;
                case 7: storeOwnMetrics = Reader.readMessage(new StoreOwnMetrics(), input); hasValue = hasValue ? hasValue : storeOwnMetrics != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, regionCount);
        size += SizeUtils.sizeOf(4, regionLeaderCount);
        size += SizeUtils.sizeOf(5, regionMetrics, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, versionInfo);
        size += SizeUtils.sizeOf(7, storeOwnMetrics);
        return size;
    }
}
