package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Coprocessor implements Message {
    private List<Integer> selectionColumns;

    private SchemaWrapper resultSchema;

    private int schemaVersion;

    private SchemaWrapper originalSchema;

    private byte[] expression;

    private int codecVersion;

    private List<Integer> groupByColumns;

    private List<AggregationOperator> aggregationOperators;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, schemaVersion, out);
        Writer.write(2, originalSchema, out);
        Writer.write(3, resultSchema, out);
        Writer.write(4, selectionColumns, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(5, expression, out);
        Writer.write(6, groupByColumns, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(7, aggregationOperators, (n, v) -> Writer.write(n, v, out));
        Writer.write(8, codecVersion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: schemaVersion = Reader.readInt(input); hasValue = true; break;
                case 2: originalSchema = Reader.readMessage(new SchemaWrapper(), input); hasValue = hasValue ? hasValue : originalSchema != null; break;
                case 3: resultSchema = Reader.readMessage(new SchemaWrapper(), input); hasValue = hasValue ? hasValue : resultSchema != null; break;
                case 4: selectionColumns = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                case 5: expression = Reader.readBytes(input); hasValue = true; break;
                case 6: groupByColumns = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                case 7: aggregationOperators = Reader.readList(aggregationOperators, input, in -> Reader.readMessage(new AggregationOperator(), in)); hasValue = true; break;
                case 8: codecVersion = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, schemaVersion);
        size += SizeUtils.sizeOf(2, originalSchema);
        size += SizeUtils.sizeOf(3, resultSchema);
        size += SizeUtils.sizeOfPack(4, selectionColumns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, expression);
        size += SizeUtils.sizeOfPack(6, groupByColumns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(7, aggregationOperators, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(8, codecVersion);
        return size;
    }
}
