package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Context implements Message {
    private IsolationLevel isolationLevel;

    private RegionEpoch regionEpoch;

    private List<Long> resolvedLocks;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, regionId, out);
        Writer.write(2, regionEpoch, out);
        Writer.write(3, isolationLevel, out);
        Writer.write(4, resolvedLocks, out, Writer::write, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: regionId = Reader.readLong(input); hasValue = true; break;
                case 2: regionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : regionEpoch != null; break;
                case 3: isolationLevel = IsolationLevel.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: resolvedLocks = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, regionId);
        size += SizeUtils.sizeOf(2, regionEpoch);
        size += SizeUtils.sizeOf(3, isolationLevel);
        size += SizeUtils.sizeOfPack(4, resolvedLocks, SizeUtils::sizeOf);
        return size;
    }
}
