package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CommitTsExpired implements Message {
    private long startTs;

    private long attemptedCommitTs;

    private byte[] key;

    private long minCommitTs;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, startTs, out);
        Writer.write(2, attemptedCommitTs, out);
        Writer.write(3, key, out);
        Writer.write(4, minCommitTs, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: startTs = Reader.readLong(input); hasValue = true; break;
                case 2: attemptedCommitTs = Reader.readLong(input); hasValue = true; break;
                case 3: key = Reader.readBytes(input); hasValue = true; break;
                case 4: minCommitTs = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, startTs);
        size += SizeUtils.sizeOf(2, attemptedCommitTs);
        size += SizeUtils.sizeOf(3, key);
        size += SizeUtils.sizeOf(4, minCommitTs);
        return size;
    }
}
