package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.CompressionType;
import io.dingodb.sdk.service.entity.common.RegionType;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.StorageBackend;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class BackupMetaRequest implements Message, Message.Request, Message.StoreRequest {
    private CompressionType compressionType;

    private StorageBackend storageBackend;

    private long backupTso;

    private String storagePath;

    private Context context;

    private int compressionLevel;

    private RegionType regionType;

    private String backupTs;

    private RequestInfo requestInfo;

    private boolean needLeader;

    private byte[] startKey;

    private byte[] endKey;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, context, out);
        Writer.write(3, startKey, out);
        Writer.write(4, endKey, out);
        Writer.write(13, needLeader, out);
        Writer.write(14, regionType, out);
        Writer.write(15, backupTs, out);
        Writer.write(16, backupTso, out);
        Writer.write(17, storagePath, out);
        Writer.write(18, storageBackend, out);
        Writer.write(19, compressionType, out);
        Writer.write(20, compressionLevel, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: context = Reader.readMessage(new Context(), input); hasValue = hasValue ? hasValue : context != null; break;
                case 3: startKey = Reader.readBytes(input); hasValue = true; break;
                case 4: endKey = Reader.readBytes(input); hasValue = true; break;
                case 13: needLeader = Reader.readBoolean(input); hasValue = true; break;
                case 14: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 15: backupTs = Reader.readString(input); hasValue = true; break;
                case 16: backupTso = Reader.readLong(input); hasValue = true; break;
                case 17: storagePath = Reader.readString(input); hasValue = true; break;
                case 18: storageBackend = Reader.readMessage(new StorageBackend(), input); hasValue = hasValue ? hasValue : storageBackend != null; break;
                case 19: compressionType = CompressionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 20: compressionLevel = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, context);
        size += SizeUtils.sizeOf(3, startKey);
        size += SizeUtils.sizeOf(4, endKey);
        size += SizeUtils.sizeOf(13, needLeader);
        size += SizeUtils.sizeOf(14, regionType);
        size += SizeUtils.sizeOf(15, backupTs);
        size += SizeUtils.sizeOf(16, backupTso);
        size += SizeUtils.sizeOf(17, storagePath);
        size += SizeUtils.sizeOf(18, storageBackend);
        size += SizeUtils.sizeOf(19, compressionType);
        size += SizeUtils.sizeOf(20, compressionLevel);
        return size;
    }
}
