package io.dingodb.sdk.service.entity.store;

import io.dingodb.sdk.service.entity.Numeric;

public enum AggregationType implements Numeric {
    UNRECOGNIZED(-1),

    AGGREGATION_NONE(0),

    SUM(1),

    COUNT(2),

    COUNTWITHNULL(3),

    MAX(4),

    MIN(5),

    SUM0(6);

    public final Integer number;

    private Object ext$;

    private AggregationType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static AggregationType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return AGGREGATION_NONE;
            case 1: return SUM;
            case 2: return COUNT;
            case 3: return COUNTWITHNULL;
            case 4: return MAX;
            case 5: return MIN;
            case 6: return SUM0;
            default: return null;
        }
    }
}
