package io.dingodb.sdk.service.entity.store;

import io.dingodb.sdk.service.entity.Numeric;

public enum Action implements Numeric {
    UNRECOGNIZED(-1),

    NoAction(0),

    TTLExpireRollback(1),

    LockNotExistRollback(2),

    MinCommitTSPushed(3),

    TTLExpirePessimisticRollback(4),

    LockNotExistDoNothing(5);

    public final Integer number;

    private Object ext$;

    private Action(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static Action forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return NoAction;
            case 1: return TTLExpireRollback;
            case 2: return LockNotExistRollback;
            case 3: return MinCommitTSPushed;
            case 4: return TTLExpirePessimisticRollback;
            case 5: return LockNotExistDoNothing;
            default: return null;
        }
    }
}
